/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPApi;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPKeyGenerator;
import org.bouncycastle.openpgp.api.OpenPGPKeyReader;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.api.bc.BcOpenPGPApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.OpenPGPKeyVersion;
import org.pgpainless.bouncycastle.PolicyAdapter;
import org.pgpainless.bouncycastle.extensions.OpenPGPKeyGeneratorExtensionsKt;
import org.pgpainless.decryption_verification.DecryptionBuilder;
import org.pgpainless.encryption_signing.EncryptionBuilder;
import org.pgpainless.key.certification.CertifyCertificate;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeyRingTemplates;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.parsing.KeyRingReader;
import org.pgpainless.policy.Policy;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0013H\u0007J\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fJ\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010 \u001a\u00020\u0013H\u0007J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u001a\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u000201H\u0007J\u001a\u0010,\u001a\u00020-2\u0006\u00102\u001a\u00020\u001f2\b\b\u0002\u00100\u001a\u000201H\u0007J\u001a\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002032\b\b\u0002\u00100\u001a\u000201H\u0007J\u000e\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020'2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020;R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006="}, d2={"Lorg/pgpainless/PGPainless;", "", "algorithmPolicy", "Lorg/pgpainless/policy/Policy;", "(Lorg/pgpainless/policy/Policy;)V", "implementation", "Lorg/bouncycastle/openpgp/api/OpenPGPImplementation;", "(Lorg/bouncycastle/openpgp/api/OpenPGPImplementation;Lorg/pgpainless/policy/Policy;)V", "getAlgorithmPolicy", "()Lorg/pgpainless/policy/Policy;", "api", "Lorg/bouncycastle/openpgp/api/OpenPGPApi;", "getImplementation", "()Lorg/bouncycastle/openpgp/api/OpenPGPImplementation;", "_buildKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKeyGenerator;", "version", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "creationTime", "Ljava/util/Date;", "buildKey", "Lorg/pgpainless/key/generation/KeyRingBuilder;", "generateCertification", "Lorg/pgpainless/key/certification/CertifyCertificate;", "generateKey", "Lorg/pgpainless/key/generation/KeyRingTemplates;", "generateMessage", "Lorg/pgpainless/encryption_signing/EncryptionBuilder;", "inspect", "Lorg/pgpainless/key/info/KeyRingInfo;", "keyOrCertificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "referenceTime", "mergeCertificate", "originalCopy", "updatedCopy", "modify", "Lorg/pgpainless/key/modification/secretkeyring/SecretKeyRingEditor;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "processMessage", "Lorg/pgpainless/decryption_verification/DecryptionBuilder;", "readKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKeyReader;", "toAsciiArmor", "", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "packetFormat", "Lorg/bouncycastle/bcpg/PacketFormat;", "certOrKey", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature;", "toCertificate", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "toKey", "secretKeyRing", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "toKeyOrCertificate", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nPGPainless.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPainless.kt\norg/pgpainless/PGPainless\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,465:1\n1855#2,2:466\n*S KotlinDebug\n*F\n+ 1 PGPainless.kt\norg/pgpainless/PGPainless\n*L\n75#1:466,2\n*E\n"})
public final class PGPainless {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenPGPImplementation implementation;
    @NotNull
    private final Policy algorithmPolicy;
    @NotNull
    private final OpenPGPApi api;
    @Nullable
    private static volatile PGPainless instance;

    public PGPainless(@NotNull OpenPGPImplementation implementation, @NotNull Policy algorithmPolicy) {
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        Intrinsics.checkNotNullParameter((Object)algorithmPolicy, (String)"algorithmPolicy");
        this.implementation = implementation;
        this.algorithmPolicy = algorithmPolicy;
        this.implementation.setPolicy((OpenPGPPolicy)new PolicyAdapter(this.algorithmPolicy));
        this.api = (OpenPGPApi)new BcOpenPGPApi(this.implementation);
    }

    public /* synthetic */ PGPainless(OpenPGPImplementation openPGPImplementation, Policy policy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            OpenPGPImplementation openPGPImplementation2 = OpenPGPImplementation.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPImplementation2, (String)"getInstance(...)");
            openPGPImplementation = openPGPImplementation2;
        }
        if ((n & 2) != 0) {
            policy = new Policy();
        }
        this(openPGPImplementation, policy);
    }

    @NotNull
    public final OpenPGPImplementation getImplementation() {
        return this.implementation;
    }

    @NotNull
    public final Policy getAlgorithmPolicy() {
        return this.algorithmPolicy;
    }

    public PGPainless(@NotNull Policy algorithmPolicy) {
        Intrinsics.checkNotNullParameter((Object)algorithmPolicy, (String)"algorithmPolicy");
        OpenPGPImplementation openPGPImplementation = OpenPGPImplementation.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPImplementation, (String)"getInstance(...)");
        this(openPGPImplementation, algorithmPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull OpenPGPCertificate certOrKey, @NotNull PacketFormat packetFormat) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)certOrKey, (String)"certOrKey");
        Intrinsics.checkNotNullParameter((Object)packetFormat, (String)"packetFormat");
        ArmoredOutputStream.Builder armorBuilder = ArmoredOutputStream.builder().clearHeaders();
        PGPPublicKey pGPPublicKey = certOrKey.getPrimaryKey().getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        Iterable iterable = ArmorUtils.Companion.keyToHeader(pGPPublicKey).getOrDefault("Comment", SetsKt.emptySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            armorBuilder.addComment(it);
        }
        String string = certOrKey.toAsciiArmoredString(packetFormat, armorBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toAsciiArmoredString(...)");
        return string;
    }

    public static /* synthetic */ String toAsciiArmor$default(PGPainless pGPainless, OpenPGPCertificate openPGPCertificate, PacketFormat packetFormat, int n, Object object) {
        if ((n & 2) != 0) {
            packetFormat = PacketFormat.ROUNDTRIP;
        }
        return pGPainless.toAsciiArmor(openPGPCertificate, packetFormat);
    }

    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull OpenPGPSignature signature, @NotNull PacketFormat packetFormat) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)packetFormat, (String)"packetFormat");
        ArmoredOutputStream.Builder armorBuilder = ArmoredOutputStream.builder().clearHeaders();
        armorBuilder.addComment(signature.getKeyIdentifier().toPrettyPrint());
        String string = signature.toAsciiArmoredString(packetFormat, armorBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toAsciiArmoredString(...)");
        return string;
    }

    public static /* synthetic */ String toAsciiArmor$default(PGPainless pGPainless, OpenPGPSignature openPGPSignature, PacketFormat packetFormat, int n, Object object) {
        if ((n & 2) != 0) {
            packetFormat = PacketFormat.ROUNDTRIP;
        }
        return pGPainless.toAsciiArmor(openPGPSignature, packetFormat);
    }

    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull PGPSignature signature, @NotNull PacketFormat packetFormat) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)packetFormat, (String)"packetFormat");
        ArmoredOutputStream.Builder armorBuilder = ArmoredOutputStream.builder().clearHeaders();
        KeyIdentifier keyIdentifier = OpenPGPSignature.getMostExpressiveIdentifier((List)signature.getKeyIdentifiers());
        if (keyIdentifier != null) {
            KeyIdentifier it = keyIdentifier;
            boolean bl = false;
            armorBuilder.addComment(it.toPrettyPrint());
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ArmoredOutputStream aOut = armorBuilder.build((OutputStream)bOut);
        BCPGOutputStream pOut = new BCPGOutputStream((OutputStream)aOut, packetFormat);
        signature.encode((OutputStream)pOut);
        pOut.close();
        aOut.close();
        String string = bOut.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toAsciiArmor$default(PGPainless pGPainless, PGPSignature pGPSignature, PacketFormat packetFormat, int n, Object object) {
        if ((n & 2) != 0) {
            packetFormat = PacketFormat.ROUNDTRIP;
        }
        return pGPainless.toAsciiArmor(pGPSignature, packetFormat);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingTemplates generateKey(@NotNull OpenPGPKeyVersion version, @NotNull Date creationTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
        return new KeyRingTemplates(version, creationTime, this);
    }

    public static /* synthetic */ KeyRingTemplates generateKey$default(PGPainless pGPainless, OpenPGPKeyVersion openPGPKeyVersion, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            openPGPKeyVersion = OpenPGPKeyVersion.v4;
        }
        if ((n & 2) != 0) {
            date = new Date();
        }
        return pGPainless.generateKey(openPGPKeyVersion, date);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingBuilder buildKey(@NotNull OpenPGPKeyVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return new KeyRingBuilder(version, this);
    }

    public static /* synthetic */ KeyRingBuilder buildKey$default(PGPainless pGPainless, OpenPGPKeyVersion openPGPKeyVersion, int n, Object object) {
        if ((n & 1) != 0) {
            openPGPKeyVersion = OpenPGPKeyVersion.v4;
        }
        return pGPainless.buildKey(openPGPKeyVersion);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKeyGenerator _buildKey(@NotNull OpenPGPKeyVersion version, @NotNull Date creationTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
        return OpenPGPKeyGeneratorExtensionsKt.setAlgorithmSuite(new OpenPGPKeyGenerator(this.implementation, version.getNumeric(), this.algorithmPolicy.getKeyProtectionSettings().getAead(), creationTime), this.algorithmPolicy.getKeyGenerationAlgorithmSuite());
    }

    public static /* synthetic */ OpenPGPKeyGenerator _buildKey$default(PGPainless pGPainless, OpenPGPKeyVersion openPGPKeyVersion, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            openPGPKeyVersion = OpenPGPKeyVersion.v4;
        }
        if ((n & 2) != 0) {
            date = new Date();
        }
        return pGPainless._buildKey(openPGPKeyVersion, date);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingInfo inspect(@NotNull OpenPGPCertificate keyOrCertificate, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter((Object)keyOrCertificate, (String)"keyOrCertificate");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        return new KeyRingInfo(keyOrCertificate, this, referenceTime);
    }

    public static /* synthetic */ KeyRingInfo inspect$default(PGPainless pGPainless, OpenPGPCertificate openPGPCertificate, Date date, int n, Object object) {
        if ((n & 2) != 0) {
            date = new Date();
        }
        return pGPainless.inspect(openPGPCertificate, date);
    }

    @JvmOverloads
    @NotNull
    public final SecretKeyRingEditor modify(@NotNull OpenPGPKey key, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        return new SecretKeyRingEditor(key, this, referenceTime);
    }

    public static /* synthetic */ SecretKeyRingEditor modify$default(PGPainless pGPainless, OpenPGPKey openPGPKey, Date date, int n, Object object) {
        if ((n & 2) != 0) {
            date = new Date();
        }
        return pGPainless.modify(openPGPKey, date);
    }

    @NotNull
    public final OpenPGPKeyReader readKey() {
        OpenPGPKeyReader openPGPKeyReader = this.api.readKeyOrCertificate();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPKeyReader, (String)"readKeyOrCertificate(...)");
        return openPGPKeyReader;
    }

    @NotNull
    public final OpenPGPKey toKey(@NotNull PGPSecretKeyRing secretKeyRing) {
        Intrinsics.checkNotNullParameter((Object)secretKeyRing, (String)"secretKeyRing");
        return new OpenPGPKey(secretKeyRing, this.implementation);
    }

    @NotNull
    public final OpenPGPCertificate toCertificate(@NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return new OpenPGPCertificate((PGPKeyRing)certificate, this.implementation);
    }

    @NotNull
    public final OpenPGPCertificate toKeyOrCertificate(@NotNull PGPKeyRing keyOrCertificate) {
        OpenPGPCertificate openPGPCertificate;
        Intrinsics.checkNotNullParameter((Object)keyOrCertificate, (String)"keyOrCertificate");
        PGPKeyRing pGPKeyRing = keyOrCertificate;
        if (pGPKeyRing instanceof PGPSecretKeyRing) {
            openPGPCertificate = (OpenPGPCertificate)this.toKey((PGPSecretKeyRing)keyOrCertificate);
        } else if (pGPKeyRing instanceof PGPPublicKeyRing) {
            openPGPCertificate = this.toCertificate((PGPPublicKeyRing)keyOrCertificate);
        } else {
            throw new IllegalArgumentException("Unexpected PGPKeyRing subclass: " + keyOrCertificate.getClass().getName());
        }
        return openPGPCertificate;
    }

    @NotNull
    public final OpenPGPCertificate mergeCertificate(@NotNull OpenPGPCertificate originalCopy, @NotNull OpenPGPCertificate updatedCopy) {
        Intrinsics.checkNotNullParameter((Object)originalCopy, (String)"originalCopy");
        Intrinsics.checkNotNullParameter((Object)updatedCopy, (String)"updatedCopy");
        OpenPGPCertificate openPGPCertificate = OpenPGPCertificate.join((OpenPGPCertificate)originalCopy, (OpenPGPCertificate)updatedCopy);
        Intrinsics.checkNotNullExpressionValue((Object)openPGPCertificate, (String)"join(...)");
        return openPGPCertificate;
    }

    @NotNull
    public final EncryptionBuilder generateMessage() {
        return new EncryptionBuilder(this);
    }

    @NotNull
    public final DecryptionBuilder processMessage() {
        return new DecryptionBuilder(this);
    }

    @NotNull
    public final CertifyCertificate generateCertification() {
        return new CertifyCertificate(this);
    }

    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull OpenPGPCertificate certOrKey) {
        Intrinsics.checkNotNullParameter((Object)certOrKey, (String)"certOrKey");
        return PGPainless.toAsciiArmor$default(this, certOrKey, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull OpenPGPSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return PGPainless.toAsciiArmor$default(this, signature, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toAsciiArmor(@NotNull PGPSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return PGPainless.toAsciiArmor$default(this, signature, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingTemplates generateKey(@NotNull OpenPGPKeyVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return PGPainless.generateKey$default(this, version, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingTemplates generateKey() {
        return PGPainless.generateKey$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingBuilder buildKey() {
        return PGPainless.buildKey$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKeyGenerator _buildKey(@NotNull OpenPGPKeyVersion version) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return PGPainless._buildKey$default(this, version, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKeyGenerator _buildKey() {
        return PGPainless._buildKey$default(this, null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final KeyRingInfo inspect(@NotNull OpenPGPCertificate keyOrCertificate) {
        Intrinsics.checkNotNullParameter((Object)keyOrCertificate, (String)"keyOrCertificate");
        return PGPainless.inspect$default(this, keyOrCertificate, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final SecretKeyRingEditor modify(@NotNull OpenPGPKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return PGPainless.modify$default(this, key, null, 2, null);
    }

    public PGPainless() {
        this(null, null, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final PGPainless getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void setInstance(@NotNull PGPainless api) {
        Companion.setInstance(api);
    }

    @JvmStatic
    @Deprecated(message="Call .generateKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateKey(version)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingTemplates generateKeyRing(@NotNull OpenPGPKeyVersion version) {
        return Companion.generateKeyRing(version);
    }

    @JvmStatic
    @Deprecated(message="Call buildKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="buildKey(version)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingBuilder buildKeyRing(@NotNull OpenPGPKeyVersion version) {
        return Companion.buildKeyRing(version);
    }

    @JvmStatic
    @Deprecated(message="Use readKey() instead.", replaceWith=@ReplaceWith(expression="readKey()", imports={}))
    @NotNull
    public static final KeyRingReader readKeyRing() {
        return Companion.readKeyRing();
    }

    @JvmStatic
    @Deprecated(message="Use .toKey() and then .toCertificate() instead.")
    @NotNull
    public static final PGPPublicKeyRing extractCertificate(@NotNull PGPSecretKeyRing secretKey) {
        return Companion.extractCertificate(secretKey);
    }

    @JvmStatic
    @Deprecated(message="Use mergeCertificate() instead.", replaceWith=@ReplaceWith(expression="mergeCertificate()", imports={}))
    @NotNull
    public static final PGPPublicKeyRing mergeCertificate(@NotNull PGPPublicKeyRing originalCopy, @NotNull PGPPublicKeyRing updatedCopy) {
        return Companion.mergeCertificate(originalCopy, updatedCopy);
    }

    @JvmStatic
    @NotNull
    public static final String asciiArmor(@NotNull PGPKeyRing key) {
        return Companion.asciiArmor(key);
    }

    @JvmStatic
    @Deprecated(message="Call getInstance().toAsciiArmor(cert) instead.", replaceWith=@ReplaceWith(expression="getInstance().toAsciiArmor(cert)", imports={}))
    @NotNull
    public static final String asciiArmor(@NotNull OpenPGPCertificate cert) {
        return Companion.asciiArmor(cert);
    }

    @JvmStatic
    public static final void asciiArmor(@NotNull PGPKeyRing key, @NotNull OutputStream outputStream) {
        Companion.asciiArmor(key, outputStream);
    }

    @JvmStatic
    @Deprecated(message="Call toAsciiArmor(signature) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="getInstance().toAsciiArmor(signature)", imports={}))
    @NotNull
    public static final String asciiArmor(@NotNull PGPSignature signature) {
        return Companion.asciiArmor(signature);
    }

    @Deprecated(message="Call generateMessage() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateMessage()", imports={}))
    @JvmStatic
    @NotNull
    public static final EncryptionBuilder encryptAndOrSign() {
        return Companion.encryptAndOrSign();
    }

    @Deprecated(message="Call processMessage() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="processMessage()", imports={}))
    @JvmStatic
    @NotNull
    public static final DecryptionBuilder decryptAndOrVerify() {
        return Companion.decryptAndOrVerify();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey, @NotNull Date referenceTime) {
        return Companion.modifyKeyRing(secretKey, referenceTime);
    }

    @JvmStatic
    @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key, @NotNull Date referenceTime) {
        return Companion.inspectKeyRing(key, referenceTime);
    }

    @JvmStatic
    @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull OpenPGPCertificate key, @NotNull Date referenceTime) {
        return Companion.inspectKeyRing(key, referenceTime);
    }

    @Deprecated(message="Use PGPainless.getInstance().getAlgorithmPolicy() instead.", replaceWith=@ReplaceWith(expression="getInstance().algorithmPolicy", imports={}))
    @JvmStatic
    @NotNull
    public static final Policy getPolicy() {
        return Companion.getPolicy();
    }

    @Deprecated(message="Call .generateCertification() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateCertification()", imports={}))
    @JvmStatic
    @NotNull
    public static final CertifyCertificate certify() {
        return Companion.certify();
    }

    @JvmStatic
    @Deprecated(message="Call .generateKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateKey(version)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingTemplates generateKeyRing() {
        return Companion.generateKeyRing();
    }

    @JvmStatic
    @Deprecated(message="Call buildKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="buildKey(version)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingBuilder buildKeyRing() {
        return Companion.buildKeyRing();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey) {
        return Companion.modifyKeyRing(secretKey);
    }

    @JvmStatic
    @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key) {
        return Companion.inspectKeyRing(key);
    }

    @JvmStatic
    @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
    @JvmOverloads
    @NotNull
    public static final KeyRingInfo inspectKeyRing(@NotNull OpenPGPCertificate key) {
        return Companion.inspectKeyRing(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0012\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\b\u0010!\u001a\u00020\"H\u0007J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\u000f2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0007J\u001a\u0010*\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010%\u001a\u00020&H\u0007J\b\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/pgpainless/PGPainless$Companion;", "", "()V", "instance", "Lorg/pgpainless/PGPainless;", "asciiArmor", "", "key", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "", "outputStream", "Ljava/io/OutputStream;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "buildKeyRing", "Lorg/pgpainless/key/generation/KeyRingBuilder;", "version", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "certify", "Lorg/pgpainless/key/certification/CertifyCertificate;", "decryptAndOrVerify", "Lorg/pgpainless/decryption_verification/DecryptionBuilder;", "encryptAndOrSign", "Lorg/pgpainless/encryption_signing/EncryptionBuilder;", "extractCertificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "generateKeyRing", "Lorg/pgpainless/key/generation/KeyRingTemplates;", "getInstance", "getPolicy", "Lorg/pgpainless/policy/Policy;", "inspectKeyRing", "Lorg/pgpainless/key/info/KeyRingInfo;", "referenceTime", "Ljava/util/Date;", "mergeCertificate", "originalCopy", "updatedCopy", "modifyKeyRing", "Lorg/pgpainless/key/modification/secretkeyring/SecretKeyRingEditor;", "readKeyRing", "Lorg/pgpainless/key/parsing/KeyRingReader;", "setInstance", "api", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nPGPainless.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PGPainless.kt\norg/pgpainless/PGPainless$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,465:1\n1#2:466\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final PGPainless getInstance() {
            PGPainless pGPainless = instance;
            if (pGPainless == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    PGPainless pGPainless2 = instance;
                    if (pGPainless2 == null) {
                        PGPainless pGPainless3;
                        PGPainless it = pGPainless3 = new PGPainless(null, null, 3, null);
                        boolean bl2 = false;
                        instance = it;
                        pGPainless2 = pGPainless3;
                    }
                    PGPainless pGPainless4 = pGPainless2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    pGPainless = pGPainless4;
                }
            }
            return pGPainless;
        }

        @JvmStatic
        public final void setInstance(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            instance = api;
        }

        @JvmStatic
        @Deprecated(message="Call .generateKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateKey(version)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingTemplates generateKeyRing(@NotNull OpenPGPKeyVersion version) {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            return PGPainless.generateKey$default(this.getInstance(), version, null, 2, null);
        }

        public static /* synthetic */ KeyRingTemplates generateKeyRing$default(Companion companion, OpenPGPKeyVersion openPGPKeyVersion, int n, Object object) {
            if ((n & 1) != 0) {
                openPGPKeyVersion = OpenPGPKeyVersion.v4;
            }
            return companion.generateKeyRing(openPGPKeyVersion);
        }

        @JvmStatic
        @Deprecated(message="Call buildKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="buildKey(version)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingBuilder buildKeyRing(@NotNull OpenPGPKeyVersion version) {
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            return this.getInstance().buildKey(version);
        }

        public static /* synthetic */ KeyRingBuilder buildKeyRing$default(Companion companion, OpenPGPKeyVersion openPGPKeyVersion, int n, Object object) {
            if ((n & 1) != 0) {
                openPGPKeyVersion = OpenPGPKeyVersion.v4;
            }
            return companion.buildKeyRing(openPGPKeyVersion);
        }

        @JvmStatic
        @Deprecated(message="Use readKey() instead.", replaceWith=@ReplaceWith(expression="readKey()", imports={}))
        @NotNull
        public final KeyRingReader readKeyRing() {
            return new KeyRingReader();
        }

        @JvmStatic
        @Deprecated(message="Use .toKey() and then .toCertificate() instead.")
        @NotNull
        public final PGPPublicKeyRing extractCertificate(@NotNull PGPSecretKeyRing secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            PGPPublicKeyRing pGPPublicKeyRing = secretKey.toCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"toCertificate(...)");
            return pGPPublicKeyRing;
        }

        @JvmStatic
        @Deprecated(message="Use mergeCertificate() instead.", replaceWith=@ReplaceWith(expression="mergeCertificate()", imports={}))
        @NotNull
        public final PGPPublicKeyRing mergeCertificate(@NotNull PGPPublicKeyRing originalCopy, @NotNull PGPPublicKeyRing updatedCopy) {
            Intrinsics.checkNotNullParameter((Object)originalCopy, (String)"originalCopy");
            Intrinsics.checkNotNullParameter((Object)updatedCopy, (String)"updatedCopy");
            PGPPublicKeyRing pGPPublicKeyRing = PGPPublicKeyRing.join((PGPPublicKeyRing)originalCopy, (PGPPublicKeyRing)updatedCopy);
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"join(...)");
            return pGPPublicKeyRing;
        }

        @JvmStatic
        @NotNull
        public final String asciiArmor(@NotNull PGPKeyRing key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return PGPainless.toAsciiArmor$default(this.getInstance(), this.getInstance().toKeyOrCertificate(key), null, 2, null);
        }

        @JvmStatic
        @Deprecated(message="Call getInstance().toAsciiArmor(cert) instead.", replaceWith=@ReplaceWith(expression="getInstance().toAsciiArmor(cert)", imports={}))
        @NotNull
        public final String asciiArmor(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            return PGPainless.toAsciiArmor$default(this.getInstance(), cert, null, 2, null);
        }

        @JvmStatic
        public final void asciiArmor(@NotNull PGPKeyRing key, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            ArmoredOutputStream armorOut = ArmorUtils.Companion.toAsciiArmoredStream(key, outputStream);
            key.encode((OutputStream)armorOut);
            armorOut.close();
        }

        @JvmStatic
        @Deprecated(message="Call toAsciiArmor(signature) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="getInstance().toAsciiArmor(signature)", imports={}))
        @NotNull
        public final String asciiArmor(@NotNull PGPSignature signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            return PGPainless.toAsciiArmor$default(this.getInstance(), signature, null, 2, null);
        }

        @Deprecated(message="Call generateMessage() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateMessage()", imports={}))
        @JvmStatic
        @NotNull
        public final EncryptionBuilder encryptAndOrSign() {
            return this.getInstance().generateMessage();
        }

        @Deprecated(message="Call processMessage() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="processMessage()", imports={}))
        @JvmStatic
        @NotNull
        public final DecryptionBuilder decryptAndOrVerify() {
            return this.getInstance().processMessage();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.getInstance().modify(this.getInstance().toKey(secretKey), referenceTime);
        }

        public static /* synthetic */ SecretKeyRingEditor modifyKeyRing$default(Companion companion, PGPSecretKeyRing pGPSecretKeyRing, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            return companion.modifyKeyRing(pGPSecretKeyRing, date);
        }

        @JvmStatic
        @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.getInstance().inspect(this.getInstance().toKeyOrCertificate(key), referenceTime);
        }

        public static /* synthetic */ KeyRingInfo inspectKeyRing$default(Companion companion, PGPKeyRing pGPKeyRing, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            return companion.inspectKeyRing(pGPKeyRing, date);
        }

        @JvmStatic
        @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull OpenPGPCertificate key, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            return this.getInstance().inspect(key, referenceTime);
        }

        public static /* synthetic */ KeyRingInfo inspectKeyRing$default(Companion companion, OpenPGPCertificate openPGPCertificate, Date date, int n, Object object) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            return companion.inspectKeyRing(openPGPCertificate, date);
        }

        @Deprecated(message="Use PGPainless.getInstance().getAlgorithmPolicy() instead.", replaceWith=@ReplaceWith(expression="getInstance().algorithmPolicy", imports={}))
        @JvmStatic
        @NotNull
        public final Policy getPolicy() {
            return this.getInstance().getAlgorithmPolicy();
        }

        @Deprecated(message="Call .generateCertification() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateCertification()", imports={}))
        @JvmStatic
        @NotNull
        public final CertifyCertificate certify() {
            return this.getInstance().generateCertification();
        }

        @JvmStatic
        @Deprecated(message="Call .generateKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="generateKey(version)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingTemplates generateKeyRing() {
            return org.pgpainless.PGPainless$Companion.generateKeyRing$default(this, null, 1, null);
        }

        @JvmStatic
        @Deprecated(message="Call buildKey() on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="buildKey(version)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingBuilder buildKeyRing() {
            return org.pgpainless.PGPainless$Companion.buildKeyRing$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SecretKeyRingEditor modifyKeyRing(@NotNull PGPSecretKeyRing secretKey) {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return org.pgpainless.PGPainless$Companion.modifyKeyRing$default(this, secretKey, null, 2, null);
        }

        @JvmStatic
        @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull PGPKeyRing key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return org.pgpainless.PGPainless$Companion.inspectKeyRing$default(this, key, null, 2, null);
        }

        @JvmStatic
        @Deprecated(message="Use inspect(key) on an instance of PGPainless instead.", replaceWith=@ReplaceWith(expression="inspect(key)", imports={}))
        @JvmOverloads
        @NotNull
        public final KeyRingInfo inspectKeyRing(@NotNull OpenPGPCertificate key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return org.pgpainless.PGPainless$Companion.inspectKeyRing$default(this, key, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

