/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.keyring.impl;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.key.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.key.selection.key.SecretKeySelectionStrategy;

public class PartialUserId {

    public static class SecRingSelectionStrategy
    extends SecretKeySelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, @Nonnull PGPSecretKey key) {
            Iterator userIds = key.getUserIDs();
            while (userIds.hasNext()) {
                String userId = (String)userIds.next();
                if (!userId.contains(identifier)) continue;
                return true;
            }
            return false;
        }
    }

    public static class PubRingSelectionStrategy
    extends PublicKeySelectionStrategy<String> {
        @Override
        public boolean accept(String identifier, @Nonnull PGPPublicKey key) {
            Iterator userIds = key.getUserIDs();
            while (userIds.hasNext()) {
                String userId = (String)userIds.next();
                if (!userId.contains(identifier)) continue;
                return true;
            }
            return false;
        }
    }
}

