/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.key.selection.key.KeySelectionStrategy;
import org.pgpainless.util.MultiMap;

public abstract class SecretKeySelectionStrategy<O>
implements KeySelectionStrategy<PGPSecretKey, PGPSecretKeyRing, O> {
    @Override
    public Set<PGPSecretKey> selectKeysFromKeyRing(O identifier, @Nonnull PGPSecretKeyRing ring) {
        HashSet<PGPSecretKey> keys = new HashSet<PGPSecretKey>();
        Iterator i = ring.getSecretKeys();
        while (i.hasNext()) {
            PGPSecretKey key = (PGPSecretKey)i.next();
            if (!this.accept(identifier, key)) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public MultiMap<O, PGPSecretKey> selectKeysFromKeyRings(@Nonnull MultiMap<O, PGPSecretKeyRing> keyRings) {
        MultiMap<O, PGPSecretKey> keys = new MultiMap<O, PGPSecretKey>();
        for (O identifier : keyRings.keySet()) {
            for (PGPSecretKeyRing ring : keyRings.get(identifier)) {
                keys.put(identifier, this.selectKeysFromKeyRing(identifier, ring));
            }
        }
        return keys;
    }
}

