/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public class PasswordBasedSecretKeyRingProtector
implements SecretKeyRingProtector {
    private static final PGPDigestCalculatorProvider calculatorProvider = new BcPGPDigestCalculatorProvider();
    protected final KeyRingProtectionSettings protectionSettings;
    protected final SecretKeyPassphraseProvider passphraseProvider;

    public PasswordBasedSecretKeyRingProtector(@Nonnull KeyRingProtectionSettings settings, @Nonnull SecretKeyPassphraseProvider passphraseProvider) {
        this.protectionSettings = settings;
        this.passphraseProvider = passphraseProvider;
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long keyId) {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : new BcPBESecretKeyDecryptorBuilder(calculatorProvider).build(passphrase.getChars());
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : new BcPBESecretKeyEncryptorBuilder(this.protectionSettings.getEncryptionAlgorithm().getAlgorithmId(), calculatorProvider.get(this.protectionSettings.getHashAlgorithm().getAlgorithmId()), this.protectionSettings.getS2kCount()).build(passphrase.getChars());
    }
}

