/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.annotation.Nonnull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.length.RsaLength;

public class RSA_GENERAL
implements KeyType {
    private final RsaLength length;

    RSA_GENERAL(@Nonnull RsaLength length) {
        this.length = length;
    }

    public static RSA_GENERAL withLength(@Nonnull RsaLength length) {
        return new RSA_GENERAL(length);
    }

    @Override
    public String getName() {
        return "RSA";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.RSA_GENERAL;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new RSAKeyGenParameterSpec(this.length.getLength(), RSAKeyGenParameterSpec.F4);
    }
}

