/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;

public class OpenPgpV4Fingerprint
implements CharSequence,
Comparable<OpenPgpV4Fingerprint> {
    public static final String SCHEME = "openpgp4fpr";
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final String fingerprint;

    public OpenPgpV4Fingerprint(@Nonnull String fingerprint) {
        String fp = fingerprint.trim().toUpperCase();
        if (!OpenPgpV4Fingerprint.isValid(fp)) {
            throw new IllegalArgumentException("Fingerprint " + fingerprint + " does not appear to be a valid OpenPGP v4 fingerprint.");
        }
        this.fingerprint = fp;
    }

    public OpenPgpV4Fingerprint(@Nonnull byte[] bytes) {
        this(new String(bytes, utf8));
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPPublicKey key) {
        this(Hex.encode((byte[])key.getFingerprint()));
        if (key.getVersion() != 4) {
            throw new IllegalArgumentException("Key is not a v4 OpenPgp key.");
        }
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPSecretKey key) {
        this(key.getPublicKey());
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPPublicKeyRing ring) {
        this(ring.getPublicKey());
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPSecretKeyRing ring) {
        this(ring.getPublicKey());
    }

    private static boolean isValid(@Nonnull String fp) {
        return fp.matches("[0-9A-F]{40}");
    }

    public long getKeyId() {
        byte[] bytes = Hex.decode((byte[])this.toString().getBytes(utf8));
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        ((Buffer)buf).position(12);
        return buf.getLong();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CharSequence)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    @Override
    public int length() {
        return this.fingerprint.length();
    }

    @Override
    public char charAt(int i) {
        return this.fingerprint.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.fingerprint.subSequence(i, i1);
    }

    @Override
    @Nonnull
    public String toString() {
        return this.fingerprint;
    }

    public URI toUri() {
        try {
            return new URI(SCHEME, this.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static OpenPgpV4Fingerprint fromUri(URI uri) {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI scheme MUST equal 'openpgp4fpr'");
        }
        return new OpenPgpV4Fingerprint(uri.getSchemeSpecificPart());
    }

    @Override
    public int compareTo(@Nonnull OpenPgpV4Fingerprint openPgpV4Fingerprint) {
        return this.fingerprint.compareTo(openPgpV4Fingerprint.fingerprint);
    }
}

