/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DetachedSignature;
import org.pgpainless.decryption_verification.OnePassSignature;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class OpenPgpMetadata {
    private final Set<Long> recipientKeyIds;
    private final OpenPgpV4Fingerprint decryptionFingerprint;
    private final List<OnePassSignature> onePassSignatures;
    private final List<DetachedSignature> detachedSignatures;
    private final SymmetricKeyAlgorithm symmetricKeyAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final boolean integrityProtected;

    public OpenPgpMetadata(Set<Long> recipientKeyIds, OpenPgpV4Fingerprint decryptionFingerprint, SymmetricKeyAlgorithm symmetricKeyAlgorithm, CompressionAlgorithm algorithm, boolean integrityProtected, List<OnePassSignature> onePassSignatures, List<DetachedSignature> detachedSignatures) {
        this.recipientKeyIds = Collections.unmodifiableSet(recipientKeyIds);
        this.decryptionFingerprint = decryptionFingerprint;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.compressionAlgorithm = algorithm;
        this.integrityProtected = integrityProtected;
        this.detachedSignatures = Collections.unmodifiableList(detachedSignatures);
        this.onePassSignatures = Collections.unmodifiableList(onePassSignatures);
    }

    public Set<Long> getRecipientKeyIds() {
        return this.recipientKeyIds;
    }

    public boolean isEncrypted() {
        return !this.getRecipientKeyIds().isEmpty();
    }

    public OpenPgpV4Fingerprint getDecryptionFingerprint() {
        return this.decryptionFingerprint;
    }

    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public boolean isIntegrityProtected() {
        return this.integrityProtected;
    }

    public Set<PGPSignature> getSignatures() {
        HashSet<PGPSignature> signatures = new HashSet<PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            signatures.add(detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            signatures.add(onePassSignature.getSignature());
        }
        return signatures;
    }

    public boolean isSigned() {
        return !this.getSignatures().isEmpty();
    }

    public Map<OpenPgpV4Fingerprint, PGPSignature> getVerifiedSignatures() {
        ConcurrentHashMap<OpenPgpV4Fingerprint, PGPSignature> verifiedSignatures = new ConcurrentHashMap<OpenPgpV4Fingerprint, PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            if (!detachedSignature.isVerified()) continue;
            verifiedSignatures.put(detachedSignature.getFingerprint(), detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            if (!onePassSignature.isVerified()) continue;
            verifiedSignatures.put(onePassSignature.getFingerprint(), onePassSignature.getSignature());
        }
        return verifiedSignatures;
    }

    public Set<OpenPgpV4Fingerprint> getVerifiedSignatureKeyFingerprints() {
        return this.getVerifiedSignatures().keySet();
    }

    public boolean isVerified() {
        return !this.getVerifiedSignatures().isEmpty();
    }

    public boolean containsVerifiedSignatureFrom(PGPPublicKeyRing publicKeys) {
        for (PGPPublicKey key : publicKeys) {
            OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(key);
            if (!this.containsVerifiedSignatureFrom(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean containsVerifiedSignatureFrom(OpenPgpV4Fingerprint fingerprint) {
        return this.getVerifiedSignatureKeyFingerprints().contains(fingerprint);
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Long> recipientFingerprints = new HashSet<Long>();
        private OpenPgpV4Fingerprint decryptionFingerprint;
        private final List<DetachedSignature> detachedSignatures = new ArrayList<DetachedSignature>();
        private final List<OnePassSignature> onePassSignatures = new ArrayList<OnePassSignature>();
        private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.NULL;
        private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
        private boolean integrityProtected = false;

        public Builder addRecipientKeyId(Long keyId) {
            this.recipientFingerprints.add(keyId);
            return this;
        }

        public Builder setDecryptionFingerprint(OpenPgpV4Fingerprint fingerprint) {
            this.decryptionFingerprint = fingerprint;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm algorithm) {
            this.compressionAlgorithm = algorithm;
            return this;
        }

        public List<DetachedSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        public Builder setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
            this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            return this;
        }

        public Builder setIntegrityProtected(boolean integrityProtected) {
            this.integrityProtected = integrityProtected;
            return this;
        }

        public void addDetachedSignature(DetachedSignature signature) {
            this.detachedSignatures.add(signature);
        }

        public void addOnePassSignature(OnePassSignature onePassSignature) {
            this.onePassSignatures.add(onePassSignature);
        }

        public OpenPgpMetadata build() {
            return new OpenPgpMetadata(this.recipientFingerprints, this.decryptionFingerprint, this.symmetricKeyAlgorithm, this.compressionAlgorithm, this.integrityProtected, this.onePassSignatures, this.detachedSignatures);
        }
    }

    public static class Signature {
        protected final PGPSignature signature;
        protected final OpenPgpV4Fingerprint fingerprint;

        public Signature(PGPSignature signature, OpenPgpV4Fingerprint fingerprint) {
            this.signature = signature;
            this.fingerprint = fingerprint;
        }
    }
}

