/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pf4j.PluginManager;
import org.pf4j.spring.SpringExtensionFactory;

public class SingletonSpringExtensionFactory
extends SpringExtensionFactory {
    private final List<String> extensionClassNames;
    private Map<String, Object> cache;

    public SingletonSpringExtensionFactory(PluginManager pluginManager) {
        this(pluginManager, true, new String[0]);
    }

    public SingletonSpringExtensionFactory(PluginManager pluginManager, String ... extensionClassNames) {
        this(pluginManager, true, extensionClassNames);
    }

    public SingletonSpringExtensionFactory(PluginManager pluginManager, boolean autowire, String ... extensionClassNames) {
        super(pluginManager, autowire);
        this.extensionClassNames = Arrays.asList(extensionClassNames);
        this.cache = new HashMap<String, Object>();
    }

    @Override
    public <T> T create(Class<T> extensionClass) {
        String extensionClassName = extensionClass.getName();
        if (this.cache.containsKey(extensionClassName)) {
            return (T)this.cache.get(extensionClassName);
        }
        T extension = super.create(extensionClass);
        if (this.extensionClassNames.isEmpty() || this.extensionClassNames.contains(extensionClassName)) {
            this.cache.put(extensionClassName, extension);
        }
        return extension;
    }
}

