/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.sample;

import com.sun.jna.Platform;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.PcapPacket;
import org.pcap4j.core.PcapStat;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.IcmpV4EchoPacket;

public class Docker {
    private static final String COUNT_KEY = Docker.class.getName() + ".count";
    private static final int COUNT = Integer.getInteger(COUNT_KEY, 5);
    private static final String READ_TIMEOUT_KEY = Docker.class.getName() + ".readTimeout";
    private static final int READ_TIMEOUT = Integer.getInteger(READ_TIMEOUT_KEY, 10);
    private static final String SNAPLEN_KEY = Docker.class.getName() + ".snaplen";
    private static final int SNAPLEN = Integer.getInteger(SNAPLEN_KEY, 65536);
    private static final String BUFFER_SIZE_KEY = Docker.class.getName() + ".bufferSize";
    private static final int BUFFER_SIZE = Integer.getInteger(BUFFER_SIZE_KEY, 0x100000);
    private static final String TIMESTAMP_PRECISION_NANO_KEY = Docker.class.getName() + ".timestampPrecision.nano";
    private static final boolean TIMESTAMP_PRECISION_NANO = Boolean.getBoolean(TIMESTAMP_PRECISION_NANO_KEY);
    private static final String NIF_NAME_KEY = Docker.class.getName() + ".nifName";
    private static final String NIF_NAME = System.getProperty(NIF_NAME_KEY);
    private static final String WAIT_KEY = Docker.class.getName() + ".wait";
    private static final boolean WAIT = Boolean.getBoolean(WAIT_KEY);

    private Docker() {
    }

    public static void main(String[] args) throws PcapNativeException, NotOpenException {
        String filter = args.length != 0 ? args[0] : "";
        System.out.println(COUNT_KEY + ": " + COUNT);
        System.out.println(READ_TIMEOUT_KEY + ": " + READ_TIMEOUT);
        System.out.println(SNAPLEN_KEY + ": " + SNAPLEN);
        System.out.println(BUFFER_SIZE_KEY + ": " + BUFFER_SIZE);
        System.out.println(TIMESTAMP_PRECISION_NANO_KEY + ": " + TIMESTAMP_PRECISION_NANO);
        System.out.println(NIF_NAME_KEY + ": " + NIF_NAME);
        System.out.println("\n");
        if (WAIT) {
            Docker.waitForPing();
        }
        PcapNetworkInterface nif = NIF_NAME != null ? Pcaps.getDevByName((String)NIF_NAME) : Pcaps.getDevByName((String)"eth0");
        System.out.println(nif.getName() + " (" + nif.getDescription() + ")");
        for (PcapAddress addr : nif.getAddresses()) {
            if (addr.getAddress() == null) continue;
            System.out.println("IP address: " + addr.getAddress());
        }
        System.out.println("");
        PcapHandle.Builder phb = new PcapHandle.Builder(nif.getName()).snaplen(SNAPLEN).promiscuousMode(PcapNetworkInterface.PromiscuousMode.PROMISCUOUS).timeoutMillis(READ_TIMEOUT).bufferSize(BUFFER_SIZE);
        if (TIMESTAMP_PRECISION_NANO) {
            phb.timestampPrecision(PcapHandle.TimestampPrecision.NANO);
        }
        PcapHandle handle = phb.build();
        handle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
        int num = 0;
        while (true) {
            PcapPacket packet;
            if ((packet = handle.getNextPacket()) == null) {
                continue;
            }
            System.out.println(packet);
            if (++num >= COUNT) break;
        }
        PcapStat ps = handle.getStats();
        System.out.println("ps_recv: " + ps.getNumPacketsReceived());
        System.out.println("ps_drop: " + ps.getNumPacketsDropped());
        System.out.println("ps_ifdrop: " + ps.getNumPacketsDroppedByIf());
        if (Platform.isWindows()) {
            System.out.println("bs_capt: " + ps.getNumPacketsCaptured());
        }
        handle.close();
    }

    private static void waitForPing() throws PcapNativeException, NotOpenException {
        PcapPacket packet;
        PcapNetworkInterface nif = Pcaps.getDevByName((String)"eth0");
        System.out.println(nif.getName() + " (" + nif.getDescription() + ")");
        for (PcapAddress addr : nif.getAddresses()) {
            if (addr.getAddress() == null) continue;
            System.out.println("IP address: " + addr.getAddress());
        }
        System.out.println("");
        PcapHandle handle = nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.NONPROMISCUOUS, 10);
        handle.setFilter("icmp", BpfProgram.BpfCompileMode.OPTIMIZE);
        while ((packet = handle.getNextPacket()) == null || !packet.contains(IcmpV4EchoPacket.class)) {
        }
        handle.close();
    }
}

