/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.sample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV4DestinationUnreachablePacket;
import org.pcap4j.packet.IcmpV4EchoPacket;
import org.pcap4j.packet.IcmpV4ParameterProblemPacket;
import org.pcap4j.packet.IcmpV4TimeExceededPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc791Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IcmpV4Code;
import org.pcap4j.packet.namednumber.IcmpV4Type;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.IcmpV4Helper;
import org.pcap4j.util.MacAddress;
import org.pcap4j.util.NifSelector;

public class IcmpV4ErrReplyer {
    private static MacAddress MAC_ADDR = MacAddress.getByName((String)"fe:00:00:00:00:01");

    private IcmpV4ErrReplyer() {
    }

    public static void main(String[] args) throws PcapNativeException, NotOpenException {
        IcmpV4DestinationUnreachablePacket.Builder tmp;
        PcapNetworkInterface nif;
        IcmpV4Code code;
        IcmpV4Type type;
        Inet4Address address;
        String strAddress = args[0];
        String strType = args[1];
        String strCode = args[2];
        try {
            address = (Inet4Address)InetAddress.getByName(strAddress);
        }
        catch (UnknownHostException e1) {
            throw new IllegalArgumentException("args[0]: " + strAddress);
        }
        try {
            type = IcmpV4Type.getInstance((Byte)Byte.parseByte(strType));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("args[1]: " + strType, e);
        }
        if (!(type.equals((Object)IcmpV4Type.DESTINATION_UNREACHABLE) || type.equals((Object)IcmpV4Type.TIME_EXCEEDED) || type.equals((Object)IcmpV4Type.PARAMETER_PROBLEM))) {
            throw new IllegalArgumentException("args[1]: " + strType);
        }
        try {
            code = IcmpV4Code.getInstance((Byte)((Byte)type.value()), (Byte)Byte.parseByte(strCode));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("args[1]: " + strType, e);
        }
        try {
            nif = new NifSelector().selectNetworkInterface();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (nif == null) {
            return;
        }
        System.out.println(nif.getName() + "(" + nif.getDescription() + ")");
        final PcapHandle handle4capture = nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        PcapHandle handle4send = nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        handle4capture.setFilter("(ether dst " + MAC_ADDR + ") or (arp and ether dst " + Pcaps.toBpfString((MacAddress)MacAddress.ETHER_BROADCAST_ADDRESS) + ")", BpfProgram.BpfCompileMode.OPTIMIZE);
        if (type.equals((Object)IcmpV4Type.DESTINATION_UNREACHABLE)) {
            tmp = new IcmpV4DestinationUnreachablePacket.Builder();
        } else if (type.equals((Object)IcmpV4Type.TIME_EXCEEDED)) {
            tmp = new IcmpV4TimeExceededPacket.Builder();
        } else if (type.equals((Object)IcmpV4Type.PARAMETER_PROBLEM)) {
            tmp = new IcmpV4ParameterProblemPacket.Builder();
        } else {
            throw new AssertionError();
        }
        IcmpV4DestinationUnreachablePacket.Builder icmpV4errb = tmp;
        IcmpV4CommonPacket.Builder icmpV4b = new IcmpV4CommonPacket.Builder();
        icmpV4b.type(type).code(code).payloadBuilder((Packet.Builder)icmpV4errb).correctChecksumAtBuild(true);
        IpV4Packet.Builder ipv4b = new IpV4Packet.Builder();
        ipv4b.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc791Tos.newInstance((byte)0)).identification((short)100).ttl((byte)100).protocol(IpNumber.ICMPV4).payloadBuilder((Packet.Builder)icmpV4b).correctChecksumAtBuild(true).correctLengthAtBuild(true);
        EthernetPacket.Builder eb = new EthernetPacket.Builder();
        eb.type(EtherType.IPV4).payloadBuilder((Packet.Builder)ipv4b).paddingAtBuild(true);
        final PacketListener listener = new PacketListener((Packet.Builder)icmpV4errb, ipv4b, eb, handle4send, address){
            final /* synthetic */ Packet.Builder val$icmpV4errb;
            final /* synthetic */ IpV4Packet.Builder val$ipv4b;
            final /* synthetic */ EthernetPacket.Builder val$eb;
            final /* synthetic */ PcapHandle val$handle4send;
            final /* synthetic */ Inet4Address val$address;
            {
                this.val$icmpV4errb = builder;
                this.val$ipv4b = builder2;
                this.val$eb = builder3;
                this.val$handle4send = pcapHandle;
                this.val$address = inet4Address;
            }

            public void gotPacket(Packet packet) {
                if (packet.contains(IcmpV4EchoPacket.class)) {
                    if (type.equals((Object)IcmpV4Type.DESTINATION_UNREACHABLE)) {
                        ((IcmpV4DestinationUnreachablePacket.Builder)this.val$icmpV4errb).payload(IcmpV4Helper.makePacketForInvokingPacketField((Packet)packet.get(IpV4Packet.class)));
                    } else if (type.equals((Object)IcmpV4Type.TIME_EXCEEDED)) {
                        ((IcmpV4TimeExceededPacket.Builder)this.val$icmpV4errb).payload(IcmpV4Helper.makePacketForInvokingPacketField((Packet)packet.get(IpV4Packet.class)));
                    } else if (type.equals((Object)IcmpV4Type.PARAMETER_PROBLEM)) {
                        ((IcmpV4ParameterProblemPacket.Builder)this.val$icmpV4errb).payload(IcmpV4Helper.makePacketForInvokingPacketField((Packet)packet.get(IpV4Packet.class)));
                    }
                    this.val$ipv4b.srcAddr(((IpV4Packet)packet.get(IpV4Packet.class)).getHeader().getDstAddr());
                    this.val$ipv4b.dstAddr(((IpV4Packet)packet.get(IpV4Packet.class)).getHeader().getSrcAddr());
                    this.val$eb.srcAddr(((EthernetPacket)packet.get(EthernetPacket.class)).getHeader().getDstAddr());
                    this.val$eb.dstAddr(((EthernetPacket)packet.get(EthernetPacket.class)).getHeader().getSrcAddr());
                    try {
                        this.val$handle4send.sendPacket((Packet)this.val$eb.build());
                    }
                    catch (PcapNativeException e) {
                        e.printStackTrace();
                    }
                    catch (NotOpenException e) {
                        e.printStackTrace();
                    }
                } else if (packet.contains(ArpPacket.class)) {
                    ArpPacket ap = (ArpPacket)packet.get(ArpPacket.class);
                    if (!ap.getHeader().getOperation().equals((Object)ArpOperation.REQUEST)) {
                        return;
                    }
                    if (!ap.getHeader().getDstProtocolAddr().equals(this.val$address)) {
                        return;
                    }
                    EthernetPacket.Builder eb = (EthernetPacket.Builder)packet.getBuilder();
                    ArpPacket.Builder ab = (ArpPacket.Builder)eb.get(ArpPacket.Builder.class);
                    ab.srcHardwareAddr(MAC_ADDR).dstHardwareAddr(ap.getHeader().getSrcHardwareAddr()).srcProtocolAddr(ap.getHeader().getDstProtocolAddr()).dstProtocolAddr(ap.getHeader().getSrcProtocolAddr()).operation(ArpOperation.REPLY);
                    eb.dstAddr(ap.getHeader().getSrcHardwareAddr()).srcAddr(MAC_ADDR);
                    try {
                        this.val$handle4send.sendPacket((Packet)eb.build());
                    }
                    catch (PcapNativeException e) {
                        e.printStackTrace();
                    }
                    catch (NotOpenException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            handle4capture.loop(-1, listener);
                        }
                    }
                    catch (PcapNativeException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InterruptedException e) {
                    }
                    catch (NotOpenException e) {
                    }
                    break;
                }
            }
        });
        IcmpV4ErrReplyer.block();
        handle4capture.breakLoop();
        handle4capture.close();
        handle4send.close();
        executor.shutdown();
    }

    private static void block() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("** Hit Enter key to stop simulation **");
            r.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

