/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.sample;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.NifSelector;

public class HeavyLoop {
    private HeavyLoop() {
    }

    public static void main(String[] args) throws PcapNativeException, NotOpenException {
        PcapNetworkInterface nif;
        try {
            nif = new NifSelector().selectNetworkInterface();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (nif == null) {
            return;
        }
        System.out.println(nif.getName() + "(" + nif.getDescription() + ")");
        final PcapHandle handle = nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        PacketListener listener = new PacketListener(){

            public void gotPacket(Packet packet) {
                System.out.println(handle.getTimestamp());
                System.out.println("start a heavy task");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("done");
            }
        };
        try {
            ExecutorService pool = Executors.newCachedThreadPool();
            handle.loop(5, listener, (Executor)pool);
            pool.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        handle.close();
    }
}

