/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalTcpOption;
import org.pcap4j.packet.TcpEndOfOptionList;
import org.pcap4j.packet.TcpMaximumSegmentSizeOption;
import org.pcap4j.packet.TcpNoOperationOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.TcpSackOption;
import org.pcap4j.packet.TcpSackPermittedOption;
import org.pcap4j.packet.TcpTimestampsOption;
import org.pcap4j.packet.TcpWindowScaleOption;
import org.pcap4j.packet.UnknownTcpOption;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.TcpOptionKind;

public final class StaticTcpOptionFactory
implements PacketFactory<TcpPacket.TcpOption, TcpOptionKind> {
    private static final StaticTcpOptionFactory INSTANCE = new StaticTcpOptionFactory();

    private StaticTcpOptionFactory() {
    }

    public static StaticTcpOptionFactory getInstance() {
        return INSTANCE;
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, TcpOptionKind number) {
        try {
            switch (Byte.toUnsignedInt((Byte)number.value())) {
                case 0: {
                    return TcpEndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return TcpNoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return TcpWindowScaleOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return TcpSackPermittedOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 5: {
                    return TcpSackOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 8: {
                    return TcpTimestampsOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, TcpOptionKind number1, TcpOptionKind number2) {
        try {
            switch (Byte.toUnsignedInt((Byte)number1.value())) {
                case 0: {
                    return TcpEndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return TcpNoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return TcpWindowScaleOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return TcpSackPermittedOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 5: {
                    return TcpSackOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 8: {
                    return TcpTimestampsOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Byte.toUnsignedInt((Byte)number2.value())) {
                case 0: {
                    return TcpEndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return TcpNoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 2: {
                    return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 3: {
                    return TcpWindowScaleOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 4: {
                    return TcpSackPermittedOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 5: {
                    return TcpSackOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 8: {
                    return TcpTimestampsOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, TcpOptionKind ... numbers) {
        try {
            for (TcpOptionKind num : numbers) {
                switch (Byte.toUnsignedInt((Byte)num.value())) {
                    case 0: {
                        return TcpEndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 1: {
                        return TcpNoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 2: {
                        return TcpMaximumSegmentSizeOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 3: {
                        return TcpWindowScaleOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 4: {
                        return TcpSackPermittedOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 5: {
                        return TcpSackOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 8: {
                        return TcpTimestampsOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

