/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import org.pcap4j.packet.DnsPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.TcpPort;

public final class StaticTcpPortPacketFactory
implements PacketFactory<Packet, TcpPort> {
    private static final StaticTcpPortPacketFactory INSTANCE = new StaticTcpPortPacketFactory();

    private StaticTcpPortPacketFactory() {
    }

    public static StaticTcpPortPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, TcpPort number) {
        try {
            switch ((Short)number.value() & 0xFFFF) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, TcpPort number1, TcpPort number2) {
        try {
            switch ((Short)number1.value() & 0xFFFF) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch ((Short)number2.value() & 0xFFFF) {
                case 53: {
                    return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, TcpPort ... numbers) {
        try {
            for (TcpPort num : numbers) {
                switch ((Short)num.value() & 0xFFFF) {
                    case 53: {
                        return DnsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

