/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.statik;

import org.pcap4j.packet.IcmpV4CommonPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtDestinationOptionsPacket;
import org.pcap4j.packet.IpV6ExtFragmentPacket;
import org.pcap4j.packet.IpV6ExtHopByHopOptionsPacket;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.IpV6ExtUnknownPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.UnknownIpV6Extension;

public final class StaticIpNumberPacketFactory
implements PacketFactory<Packet, IpNumber> {
    private static final StaticIpNumberPacketFactory INSTANCE = new StaticIpNumberPacketFactory();

    private StaticIpNumberPacketFactory() {
    }

    public static StaticIpNumberPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IpNumber number) {
        try {
            switch ((Byte)number.value() & 0xFF) {
                case 0: {
                    return IpV6ExtHopByHopOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IcmpV4CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 6: {
                    return TcpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 17: {
                    return UdpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 43: {
                    return IpV6ExtRoutingPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 44: {
                    return IpV6ExtFragmentPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 58: {
                    return IcmpV6CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 59: {
                    return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 60: {
                    return IpV6ExtDestinationOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 132: {
                    return SctpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (number == UnknownIpV6Extension.getInstance()) {
                return IpV6ExtUnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IpNumber number1, IpNumber number2) {
        try {
            switch ((Byte)number1.value() & 0xFF) {
                case 0: {
                    return IpV6ExtHopByHopOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IcmpV4CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 6: {
                    return TcpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 17: {
                    return UdpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 43: {
                    return IpV6ExtRoutingPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 44: {
                    return IpV6ExtFragmentPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 58: {
                    return IcmpV6CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 59: {
                    return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 60: {
                    return IpV6ExtDestinationOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 132: {
                    return SctpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (number1 == UnknownIpV6Extension.getInstance()) {
                return IpV6ExtUnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            switch ((Byte)number2.value() & 0xFF) {
                case 0: {
                    return IpV6ExtHopByHopOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IcmpV4CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 6: {
                    return TcpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 17: {
                    return UdpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 43: {
                    return IpV6ExtRoutingPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 44: {
                    return IpV6ExtFragmentPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 58: {
                    return IcmpV6CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 59: {
                    return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 60: {
                    return IpV6ExtDestinationOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 132: {
                    return SctpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (number2 == UnknownIpV6Extension.getInstance()) {
                return IpV6ExtUnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, IpNumber ... numbers) {
        try {
            for (IpNumber num : numbers) {
                switch ((Byte)num.value() & 0xFF) {
                    case 0: {
                        return IpV6ExtHopByHopOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 1: {
                        return IcmpV4CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 6: {
                        return TcpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 17: {
                        return UdpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 43: {
                        return IpV6ExtRoutingPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 44: {
                        return IpV6ExtFragmentPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 58: {
                        return IcmpV6CommonPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 59: {
                        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 60: {
                        return IpV6ExtDestinationOptionsPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 132: {
                        return SctpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
                if (num != UnknownIpV6Extension.getInstance()) continue;
                return IpV6ExtUnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

