/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IllegalIpV4Option;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4EndOfOptionList;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.packet.IpV4LooseSourceRouteOption;
import org.pcap4j.packet.IpV4NoOperationOption;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4RecordRouteOption;
import org.pcap4j.packet.IpV4Rfc791SecurityOption;
import org.pcap4j.packet.IpV4StreamIdOption;
import org.pcap4j.packet.IpV4StrictSourceRouteOption;
import org.pcap4j.packet.UnknownIpV4Option;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV4OptionType;

public final class StaticIpV4OptionFactory
implements PacketFactory<IpV4Packet.IpV4Option, IpV4OptionType> {
    private static final StaticIpV4OptionFactory INSTANCE = new StaticIpV4OptionFactory();

    private StaticIpV4OptionFactory() {
    }

    public static StaticIpV4OptionFactory getInstance() {
        return INSTANCE;
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData, int offset, int length) {
        try {
            return UnknownIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData, int offset, int length, IpV4OptionType number) {
        try {
            switch (Byte.toUnsignedInt((Byte)number.value())) {
                case 0: {
                    return IpV4EndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IpV4NoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 7: {
                    return IpV4RecordRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 68: {
                    return IpV4InternetTimestampOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 130: {
                    return IpV4Rfc791SecurityOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 131: {
                    return IpV4LooseSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IpV4StreamIdOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IpV4StrictSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData, int offset, int length, IpV4OptionType number1, IpV4OptionType number2) {
        try {
            switch (Byte.toUnsignedInt((Byte)number1.value())) {
                case 0: {
                    return IpV4EndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IpV4NoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 7: {
                    return IpV4RecordRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 68: {
                    return IpV4InternetTimestampOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 130: {
                    return IpV4Rfc791SecurityOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 131: {
                    return IpV4LooseSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IpV4StreamIdOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IpV4StrictSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Byte.toUnsignedInt((Byte)number2.value())) {
                case 0: {
                    return IpV4EndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return IpV4NoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 7: {
                    return IpV4RecordRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 68: {
                    return IpV4InternetTimestampOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 130: {
                    return IpV4Rfc791SecurityOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 131: {
                    return IpV4LooseSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 136: {
                    return IpV4StreamIdOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
                case 137: {
                    return IpV4StrictSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData, int offset, int length, IpV4OptionType ... numbers) {
        try {
            for (IpV4OptionType num : numbers) {
                switch (Byte.toUnsignedInt((Byte)num.value())) {
                    case 0: {
                        return IpV4EndOfOptionList.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 1: {
                        return IpV4NoOperationOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 7: {
                        return IpV4RecordRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 68: {
                        return IpV4InternetTimestampOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 130: {
                        return IpV4Rfc791SecurityOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 131: {
                        return IpV4LooseSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 136: {
                        return IpV4StreamIdOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                    case 137: {
                        return IpV4StrictSourceRouteOption.newInstance((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV4Option.newInstance((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

