/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.EtherType;

public final class StaticEtherTypePacketFactory
implements PacketFactory<Packet, EtherType> {
    private static final StaticEtherTypePacketFactory INSTANCE = new StaticEtherTypePacketFactory();

    private StaticEtherTypePacketFactory() {
    }

    public static StaticEtherTypePacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, EtherType number) {
        try {
            short val = (Short)number.value();
            switch (Short.toUnsignedInt(val)) {
                case 2048: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2054: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 33024: {
                    return Dot1qVlanTagPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 34525: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if ((val & 0xFFFF) <= 1500) {
                return LlcPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, EtherType number1, EtherType number2) {
        try {
            short val = (Short)number1.value();
            switch (Short.toUnsignedInt(val)) {
                case 2048: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2054: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 33024: {
                    return Dot1qVlanTagPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 34525: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if ((val & 0xFFFF) <= 1500) {
                return LlcPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            val = (Short)number2.value();
            switch (Short.toUnsignedInt(val)) {
                case 2048: {
                    return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 2054: {
                    return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 33024: {
                    return Dot1qVlanTagPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 34525: {
                    return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if ((val & 0xFFFF) <= 1500) {
                return LlcPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, EtherType ... numbers) {
        try {
            for (EtherType num : numbers) {
                short val = (Short)num.value();
                switch (Short.toUnsignedInt(val)) {
                    case 2048: {
                        return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 2054: {
                        return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 33024: {
                        return Dot1qVlanTagPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 34525: {
                        return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
                if ((val & 0xFFFF) > 1500) continue;
                return LlcPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

