/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.Ssh2KexInitPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;

public final class StaticSsh2MessageNumberPacketFactory
implements PacketFactory<Packet, Ssh2MessageNumber> {
    private static final StaticSsh2MessageNumberPacketFactory INSTANCE = new StaticSsh2MessageNumberPacketFactory();

    private StaticSsh2MessageNumberPacketFactory() {
    }

    public static StaticSsh2MessageNumberPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Ssh2MessageNumber number) {
        try {
            switch (Byte.toUnsignedInt((Byte)number.value())) {
                case 20: {
                    return Ssh2KexInitPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Ssh2MessageNumber number1, Ssh2MessageNumber number2) {
        try {
            switch (Byte.toUnsignedInt((Byte)number1.value())) {
                case 20: {
                    return Ssh2KexInitPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            switch (Byte.toUnsignedInt((Byte)number2.value())) {
                case 20: {
                    return Ssh2KexInitPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Ssh2MessageNumber ... numbers) {
        try {
            for (Ssh2MessageNumber num : numbers) {
                switch (Byte.toUnsignedInt((Byte)num.value())) {
                    case 20: {
                        return Ssh2KexInitPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

