/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.BsdLoopbackPacket;
import org.pcap4j.packet.Dot11Selector;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.HdlcPppPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpSelector;
import org.pcap4j.packet.LinuxSllPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PppSelector;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.DataLinkType;

public final class StaticDataLinkTypePacketFactory
implements PacketFactory<Packet, DataLinkType> {
    private static final StaticDataLinkTypePacketFactory INSTANCE = new StaticDataLinkTypePacketFactory();
    private static final int RAW = (Integer)DataLinkType.RAW.value();

    private StaticDataLinkTypePacketFactory() {
    }

    public static StaticDataLinkTypePacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
    }

    public Packet newInstance(byte[] rawData, int offset, int length, DataLinkType number) {
        try {
            int val = (Integer)number.value();
            switch (val) {
                case 0: {
                    return BsdLoopbackPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 9: {
                    return PppSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 50: {
                    return HdlcPppPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 105: {
                    return Dot11Selector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 113: {
                    return LinuxSllPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 127: {
                    return RadiotapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (RAW == val) {
                return IpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, DataLinkType number1, DataLinkType number2) {
        try {
            int val = (Integer)number1.value();
            switch (val) {
                case 0: {
                    return BsdLoopbackPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 9: {
                    return PppSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 50: {
                    return HdlcPppPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 105: {
                    return Dot11Selector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 113: {
                    return LinuxSllPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 127: {
                    return RadiotapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (RAW == val) {
                return IpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            val = (Integer)number2.value();
            switch (val) {
                case 0: {
                    return BsdLoopbackPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 1: {
                    return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 9: {
                    return PppSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 50: {
                    return HdlcPppPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 105: {
                    return Dot11Selector.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 113: {
                    return LinuxSllPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
                case 127: {
                    return RadiotapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                }
            }
            if (RAW == val) {
                return IpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }

    public Packet newInstance(byte[] rawData, int offset, int length, DataLinkType ... numbers) {
        try {
            for (DataLinkType num : numbers) {
                int val = (Integer)num.value();
                switch (val) {
                    case 0: {
                        return BsdLoopbackPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 1: {
                        return EthernetPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 9: {
                        return PppSelector.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 50: {
                        return HdlcPppPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 105: {
                        return Dot11Selector.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 113: {
                        return LinuxSllPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                    case 127: {
                        return RadiotapPacket.newPacket((byte[])rawData, (int)offset, (int)length);
                    }
                }
                if (RAW != val) continue;
                return IpSelector.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            return UnknownPacket.newPacket((byte[])rawData, (int)offset, (int)length);
        }
        catch (IllegalRawDataException e) {
            return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length, (IllegalRawDataException)e);
        }
    }
}

