/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.Dot1qVlanTagPacket;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.AbstractStaticPacketFactory;
import org.pcap4j.packet.factory.PacketInstantiater;
import org.pcap4j.packet.namednumber.EtherType;

public final class StaticEtherTypePacketFactory
extends AbstractStaticPacketFactory<EtherType> {
    private static final StaticEtherTypePacketFactory INSTANCE = new StaticEtherTypePacketFactory();

    private StaticEtherTypePacketFactory() {
        this.instantiaters.put(EtherType.IPV4, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV4Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV4Packet> getTargetClass() {
                return IpV4Packet.class;
            }
        });
        this.instantiaters.put(EtherType.ARP, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return ArpPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<ArpPacket> getTargetClass() {
                return ArpPacket.class;
            }
        });
        this.instantiaters.put(EtherType.DOT1Q_VLAN_TAGGED_FRAMES, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return Dot1qVlanTagPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<Dot1qVlanTagPacket> getTargetClass() {
                return Dot1qVlanTagPacket.class;
            }
        });
        this.instantiaters.put(EtherType.IPV6, new PacketInstantiater(){

            @Override
            public Packet newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
                return IpV6Packet.newPacket((byte[])rawData, (int)offset, (int)length);
            }

            public Class<IpV6Packet> getTargetClass() {
                return IpV6Packet.class;
            }
        });
    }

    public static StaticEtherTypePacketFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Packet newInstance(byte[] rawData, int offset, int length, EtherType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        PacketInstantiater instantiater = (PacketInstantiater)this.instantiaters.get(number);
        if (instantiater != null) {
            try {
                return instantiater.newInstance(rawData, offset, length);
            }
            catch (IllegalRawDataException e) {
                return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
        }
        if (((Short)number.value() & 0xFFFF) <= 1500) {
            try {
                return LlcPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            catch (IllegalRawDataException e) {
                IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
        }
        return this.newInstance(rawData, offset, length);
    }
}

