/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalIpV6Option;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.IpV6Pad1Option;
import org.pcap4j.packet.IpV6PadNOption;
import org.pcap4j.packet.UnknownIpV6Option;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV6OptionType;

public final class StaticIpV6OptionFactory
implements PacketFactory<IpV6ExtOptionsPacket.IpV6Option, IpV6OptionType> {
    private static final StaticIpV6OptionFactory INSTANCE = new StaticIpV6OptionFactory();
    private final Map<IpV6OptionType, Instantiater> instantiaters = new HashMap<IpV6OptionType, Instantiater>();

    private StaticIpV6OptionFactory() {
        this.instantiaters.put(IpV6OptionType.PAD1, new Instantiater(){

            @Override
            public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) throws IllegalRawDataException {
                return IpV6Pad1Option.newInstance((byte[])rawData);
            }

            public Class<IpV6Pad1Option> getTargetClass() {
                return IpV6Pad1Option.class;
            }
        });
        this.instantiaters.put(IpV6OptionType.PADN, new Instantiater(){

            @Override
            public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) throws IllegalRawDataException {
                return IpV6PadNOption.newInstance((byte[])rawData);
            }

            public Class<IpV6PadNOption> getTargetClass() {
                return IpV6PadNOption.class;
            }
        });
    }

    public static StaticIpV6OptionFactory getInstance() {
        return INSTANCE;
    }

    public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData, IpV6OptionType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6Option.newInstance((byte[])rawData);
        }
        return this.newInstance(rawData);
    }

    public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) {
        try {
            return UnknownIpV6Option.newInstance((byte[])rawData);
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6Option.newInstance((byte[])rawData);
        }
    }

    public Class<? extends IpV6ExtOptionsPacket.IpV6Option> getTargetClass(IpV6OptionType number) {
        if (number == null) {
            throw new NullPointerException("number must not be null.");
        }
        Instantiater instantiater = this.instantiaters.get(number);
        return instantiater != null ? instantiater.getTargetClass() : this.getTargetClass();
    }

    public Class<? extends IpV6ExtOptionsPacket.IpV6Option> getTargetClass() {
        return UnknownIpV6Option.class;
    }

    private static interface Instantiater {
        public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] var1) throws IllegalRawDataException;

        public Class<? extends IpV6ExtOptionsPacket.IpV6Option> getTargetClass();
    }
}

