/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalIpV6RoutingData;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.IpV6RoutingSourceRouteData;
import org.pcap4j.packet.UnknownIpV6RoutingData;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV6RoutingHeaderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticIpV6RoutingDataFactory
implements PacketFactory<IpV6ExtRoutingPacket.IpV6RoutingData, IpV6RoutingHeaderType> {
    private static final StaticIpV6RoutingDataFactory INSTANCE = new StaticIpV6RoutingDataFactory();
    private final Map<IpV6RoutingHeaderType, Instantiater> instantiaters = new HashMap<IpV6RoutingHeaderType, Instantiater>();

    private StaticIpV6RoutingDataFactory() {
        this.instantiaters.put(IpV6RoutingHeaderType.SOURCE_ROUTE, new Instantiater(){

            public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData) {
                return IpV6RoutingSourceRouteData.newInstance((byte[])rawData);
            }
        });
    }

    public static StaticIpV6RoutingDataFactory getInstance() {
        return INSTANCE;
    }

    public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData, IpV6RoutingHeaderType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6RoutingData.newInstance((byte[])rawData);
        }
        return UnknownIpV6RoutingData.newInstance((byte[])rawData);
    }

    public IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] rawData) {
        return UnknownIpV6RoutingData.newInstance((byte[])rawData);
    }

    private static abstract class Instantiater {
        private Instantiater() {
        }

        public abstract IpV6ExtRoutingPacket.IpV6RoutingData newInstance(byte[] var1);
    }
}

