/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalIpV6Option;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.IpV6Pad1Option;
import org.pcap4j.packet.IpV6PadNOption;
import org.pcap4j.packet.UnknownIpV6Option;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV6OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticIpV6OptionFactory
implements PacketFactory<IpV6ExtOptionsPacket.IpV6Option, IpV6OptionType> {
    private static final StaticIpV6OptionFactory INSTANCE = new StaticIpV6OptionFactory();
    private final Map<IpV6OptionType, Instantiater> instantiaters = new HashMap<IpV6OptionType, Instantiater>();

    private StaticIpV6OptionFactory() {
        this.instantiaters.put(IpV6OptionType.PAD1, new Instantiater(){

            public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) {
                return IpV6Pad1Option.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV6OptionType.PADN, new Instantiater(){

            public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) {
                return IpV6PadNOption.newInstance((byte[])rawData);
            }
        });
    }

    public static StaticIpV6OptionFactory getInstance() {
        return INSTANCE;
    }

    public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData, IpV6OptionType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV6Option.newInstance((byte[])rawData);
        }
        return UnknownIpV6Option.newInstance((byte[])rawData);
    }

    public IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] rawData) {
        return UnknownIpV6Option.newInstance((byte[])rawData);
    }

    private static abstract class Instantiater {
        private Instantiater() {
        }

        public abstract IpV6ExtOptionsPacket.IpV6Option newInstance(byte[] var1);
    }
}

