/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.IllegalIpV4Option;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4EndOfOptionList;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.packet.IpV4LooseSourceRouteOption;
import org.pcap4j.packet.IpV4NoOperationOption;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4RecordRouteOption;
import org.pcap4j.packet.IpV4Rfc791SecurityOption;
import org.pcap4j.packet.IpV4StreamIdOption;
import org.pcap4j.packet.IpV4StrictSourceRouteOption;
import org.pcap4j.packet.UnknownIpV4Option;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpV4OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticIpV4OptionFactory
implements PacketFactory<IpV4Packet.IpV4Option, IpV4OptionType> {
    private static final StaticIpV4OptionFactory INSTANCE = new StaticIpV4OptionFactory();
    private final Map<IpV4OptionType, Instantiater> instantiaters = new HashMap<IpV4OptionType, Instantiater>();

    private StaticIpV4OptionFactory() {
        this.instantiaters.put(IpV4OptionType.END_OF_OPTION_LIST, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4EndOfOptionList.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.NO_OPERATION, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4NoOperationOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.SECURITY, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4Rfc791SecurityOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.LOOSE_SOURCE_ROUTING, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4LooseSourceRouteOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.INTERNET_TIMESTAMP, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4InternetTimestampOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.RECORD_ROUTE, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4RecordRouteOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.STREAM_ID, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4StreamIdOption.newInstance((byte[])rawData);
            }
        });
        this.instantiaters.put(IpV4OptionType.STRICT_SOURCE_ROUTING, new Instantiater(){

            public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
                return IpV4StrictSourceRouteOption.newInstance((byte[])rawData);
            }
        });
    }

    public static StaticIpV4OptionFactory getInstance() {
        return INSTANCE;
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData, IpV4OptionType number) {
        if (rawData == null || number == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" number: ").append(number);
            throw new NullPointerException(sb.toString());
        }
        try {
            Instantiater instantiater = this.instantiaters.get(number);
            if (instantiater != null) {
                return instantiater.newInstance(rawData);
            }
        }
        catch (IllegalRawDataException e) {
            return IllegalIpV4Option.newInstance((byte[])rawData);
        }
        return UnknownIpV4Option.newInstance((byte[])rawData);
    }

    public IpV4Packet.IpV4Option newInstance(byte[] rawData) {
        return UnknownIpV4Option.newInstance((byte[])rawData);
    }

    private static abstract class Instantiater {
        private Instantiater() {
        }

        public abstract IpV4Packet.IpV4Option newInstance(byte[] var1);
    }
}

