/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.propertiesbased;

import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc1349Tos;
import org.pcap4j.packet.IpV6ExtOptionsPacket;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.IpV6SimpleFlowLabel;
import org.pcap4j.packet.IpV6SimpleTrafficClass;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.UnknownDnsRData;
import org.pcap4j.packet.UnknownIpV4InternetTimestampOptionData;
import org.pcap4j.packet.UnknownIpV4Option;
import org.pcap4j.packet.UnknownIpV6NeighborDiscoveryOption;
import org.pcap4j.packet.UnknownIpV6Option;
import org.pcap4j.packet.UnknownIpV6RoutingData;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.UnknownRadiotapData;
import org.pcap4j.packet.UnknownSctpChunk;
import org.pcap4j.packet.UnknownTcpOption;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpV4InternetTimestampOptionFlag;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.packet.namednumber.IpV6OptionType;
import org.pcap4j.packet.namednumber.IpV6RoutingType;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.packet.namednumber.RadiotapPresentBitNumber;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.PropertiesLoader;

public final class PacketFactoryPropertiesLoader {
    public static final String PACKET_FACTORY_PROPERTIES_PATH_KEY = PacketFactoryPropertiesLoader.class.getPackage().getName() + ".properties";
    public static final String PACKET_CLASS_KEY_BASE = Packet.class.getName() + ".classFor.";
    public static final String UNKNOWN_PACKET_CLASS_KEY = PACKET_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV4_OPTION_CLASS_KEY_BASE = IpV4Packet.IpV4Option.class.getName() + ".classFor.";
    public static final String UNKNOWN_IPV4_OPTION_KEY = IPV4_OPTION_CLASS_KEY_BASE + "unknownNumber";
    public static final String TCP_OPTION_CLASS_KEY_BASE = TcpPacket.TcpOption.class.getName() + ".classFor.";
    public static final String UNKNOWN_TCP_OPTION_KEY = TCP_OPTION_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV4_INTERNET_TIMESTAMP_DATA_CLASS_KEY_BASE = IpV4InternetTimestampOption.IpV4InternetTimestampOptionData.class.getName() + ".classFor.";
    public static final String UNKNOWN_IPV4_INTERNET_TIMESTAMP_DATA_KEY = IPV4_OPTION_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV6_OPTION_CLASS_KEY_BASE = IpV6ExtOptionsPacket.IpV6Option.class.getName() + ".classFor.";
    public static final String UNKNOWN_IPV6_OPTION_KEY = IPV6_OPTION_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV6_ROUTING_DATA_CLASS_KEY_BASE = IpV6ExtRoutingPacket.IpV6RoutingData.class.getName() + ".classFor.";
    public static final String UNKNOWN_IPV6_ROUTING_DATA_KEY = IPV6_ROUTING_DATA_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV6_NEIGHBOR_DISCOVERY_OPTION_CLASS_KEY_BASE = IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class.getName() + ".classFor.";
    public static final String UNKNOWN_IPV6_NEIGHBOR_DISCOVERY_OPTION_KEY = IPV6_NEIGHBOR_DISCOVERY_OPTION_CLASS_KEY_BASE + "unknownNumber";
    public static final String RADIOTAP_DATA_FIELD_CLASS_KEY_BASE = RadiotapPacket.RadiotapData.class.getName() + ".classFor.";
    public static final String UNKNOWN_RADIOTAP_DATA_FIELD_KEY = RADIOTAP_DATA_FIELD_CLASS_KEY_BASE + "unknownNumber";
    public static final String SCTP_CHUNK_CLASS_KEY_BASE = SctpPacket.SctpChunk.class.getName() + ".classFor.";
    public static final String UNKNOWN_SCTP_CHUNK_KEY = SCTP_CHUNK_CLASS_KEY_BASE + "unknownNumber";
    public static final String DNS_RDATA_CLASS_KEY_BASE = DnsResourceRecord.DnsRData.class.getName() + ".classFor.";
    public static final String UNKNOWN_DNS_RDATA_KEY = DNS_RDATA_CLASS_KEY_BASE + "unknownNumber";
    public static final String IPV4_TOS_CLASS_KEY = IpV4Packet.IpV4Tos.class.getName() + ".class";
    public static final String IPV6_TRAFFIC_CLASS_CLASS_KEY = IpV6Packet.IpV6TrafficClass.class.getName() + ".class";
    public static final String IPV6_FLOW_LABEL_CLASS_KEY = IpV6Packet.IpV6FlowLabel.class.getName() + ".class";
    private static final PacketFactoryPropertiesLoader INSTANCE = new PacketFactoryPropertiesLoader();
    private PropertiesLoader loader = new PropertiesLoader(System.getProperty(PACKET_FACTORY_PROPERTIES_PATH_KEY, PacketFactoryPropertiesLoader.class.getPackage().getName().replace('.', '/') + "/packet-factory.properties"), true, true);

    private PacketFactoryPropertiesLoader() {
    }

    public static PacketFactoryPropertiesLoader getInstance() {
        return INSTANCE;
    }

    public <T extends NamedNumber<?, ?>> Class<? extends Packet> getPacketClass(T number) {
        EtherType et;
        String val = number.valueAsString();
        if (number instanceof EtherType && ((Short)(et = (EtherType)number).value() & 0xFFFF) <= 1500) {
            val = "LLC";
        }
        StringBuilder sb = new StringBuilder(110);
        sb.append(PACKET_CLASS_KEY_BASE).append(number.getClass().getName()).append(".").append(val);
        return this.loader.getClass(sb.toString(), this.getUnknownPacketClass());
    }

    public Class<? extends Packet> getUnknownPacketClass() {
        return this.loader.getClass(UNKNOWN_PACKET_CLASS_KEY, UnknownPacket.class);
    }

    public Class<? extends PacketFactory<?, ?>> getPacketFactoryClass(Class<?> targetClass, Class<? extends NamedNumber<?, ?>> numberClass) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(targetClass.getName());
        if (!numberClass.equals(NotApplicable.class)) {
            sb.append(".classifiedBy.").append(numberClass.getName());
        }
        sb.append(".isMadeBy");
        String key = sb.toString();
        Class factory = this.loader.getClass(key, null);
        if (factory == null) {
            String value = this.loader.getProp().getProperty(key);
            if (value == null) {
                throw new IllegalStateException("Can't get a value by the key: " + key);
            }
            sb = new StringBuilder(110);
            sb.append("Invalid value(").append(value).append(") for the key: ").append(key);
            throw new IllegalStateException(sb.toString());
        }
        return factory;
    }

    public Class<? extends IpV4Packet.IpV4Option> getIpV4OptionClass(IpV4OptionType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(IPV4_OPTION_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownIpV4OptionClass());
    }

    public Class<? extends IpV4Packet.IpV4Option> getUnknownIpV4OptionClass() {
        return this.loader.getClass(UNKNOWN_IPV4_OPTION_KEY, UnknownIpV4Option.class);
    }

    public Class<? extends TcpPacket.TcpOption> getTcpOptionClass(TcpOptionKind type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(TCP_OPTION_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownTcpOptionClass());
    }

    public Class<? extends TcpPacket.TcpOption> getUnknownTcpOptionClass() {
        return this.loader.getClass(UNKNOWN_TCP_OPTION_KEY, UnknownTcpOption.class);
    }

    public Class<? extends IpV4InternetTimestampOption.IpV4InternetTimestampOptionData> getIpV4InternetTimestampDataClass(IpV4InternetTimestampOptionFlag flag) {
        StringBuilder sb = new StringBuilder(150);
        sb.append(IPV4_INTERNET_TIMESTAMP_DATA_CLASS_KEY_BASE).append(flag.getClass().getName()).append(".").append(flag.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownIpV4InternetTimestampDataClass());
    }

    public Class<? extends IpV4InternetTimestampOption.IpV4InternetTimestampOptionData> getUnknownIpV4InternetTimestampDataClass() {
        return this.loader.getClass(UNKNOWN_IPV4_INTERNET_TIMESTAMP_DATA_KEY, UnknownIpV4InternetTimestampOptionData.class);
    }

    public Class<? extends IpV6ExtOptionsPacket.IpV6Option> getIpV6OptionClass(IpV6OptionType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(IPV6_OPTION_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownIpV6OptionClass());
    }

    public Class<? extends IpV6ExtOptionsPacket.IpV6Option> getUnknownIpV6OptionClass() {
        return this.loader.getClass(UNKNOWN_IPV6_OPTION_KEY, UnknownIpV6Option.class);
    }

    public Class<? extends IpV6ExtRoutingPacket.IpV6RoutingData> getIpV6RoutingDataClass(IpV6RoutingType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(IPV6_ROUTING_DATA_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownIpV6RoutingDataClass());
    }

    public Class<? extends IpV6ExtRoutingPacket.IpV6RoutingData> getUnknownIpV6RoutingDataClass() {
        return this.loader.getClass(UNKNOWN_IPV6_ROUTING_DATA_KEY, UnknownIpV6RoutingData.class);
    }

    public Class<? extends IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getIpV6NeighborDiscoveryOptionClass(IpV6NeighborDiscoveryOptionType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(IPV6_NEIGHBOR_DISCOVERY_OPTION_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownIpV6NeighborDiscoveryOptionClass());
    }

    public Class<? extends IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getUnknownIpV6NeighborDiscoveryOptionClass() {
        return this.loader.getClass(UNKNOWN_IPV6_NEIGHBOR_DISCOVERY_OPTION_KEY, UnknownIpV6NeighborDiscoveryOption.class);
    }

    public Class<? extends RadiotapPacket.RadiotapData> getRadiotapDataFieldClass(RadiotapPresentBitNumber num) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(RADIOTAP_DATA_FIELD_CLASS_KEY_BASE).append(num.getClass().getName()).append(".").append(num.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownRadiotapDataFieldClass());
    }

    public Class<? extends RadiotapPacket.RadiotapData> getUnknownRadiotapDataFieldClass() {
        return this.loader.getClass(UNKNOWN_RADIOTAP_DATA_FIELD_KEY, UnknownRadiotapData.class);
    }

    public Class<? extends SctpPacket.SctpChunk> getSctpChunkClass(SctpChunkType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(SCTP_CHUNK_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownSctpChunkClass());
    }

    public Class<? extends SctpPacket.SctpChunk> getUnknownSctpChunkClass() {
        return this.loader.getClass(UNKNOWN_SCTP_CHUNK_KEY, UnknownSctpChunk.class);
    }

    public Class<? extends DnsResourceRecord.DnsRData> getDnsRDataClass(DnsResourceRecordType type) {
        StringBuilder sb = new StringBuilder(120);
        sb.append(DNS_RDATA_CLASS_KEY_BASE).append(type.getClass().getName()).append(".").append(type.valueAsString());
        return this.loader.getClass(sb.toString(), this.getUnknownDnsRDataClass());
    }

    public Class<? extends DnsResourceRecord.DnsRData> getUnknownDnsRDataClass() {
        return this.loader.getClass(UNKNOWN_DNS_RDATA_KEY, UnknownDnsRData.class);
    }

    public Class<? extends IpV4Packet.IpV4Tos> getIpV4TosClass() {
        return this.loader.getClass(IPV4_TOS_CLASS_KEY, IpV4Rfc1349Tos.class);
    }

    public Class<? extends IpV6Packet.IpV6TrafficClass> getIpV6TrafficClassClass() {
        return this.loader.getClass(IPV6_TRAFFIC_CLASS_CLASS_KEY, IpV6SimpleTrafficClass.class);
    }

    public Class<? extends IpV6Packet.IpV6FlowLabel> getIpV6FlowLabelClass() {
        return this.loader.getClass(IPV6_FLOW_LABEL_CLASS_KEY, IpV6SimpleFlowLabel.class);
    }
}

