/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.propertiesbased;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalTcpOption;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.propertiesbased.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.TcpOptionKind;

public final class PropertiesBasedTcpOptionFactory
implements PacketFactory<TcpPacket.TcpOption, TcpOptionKind> {
    private static final PropertiesBasedTcpOptionFactory INSTANCE = new PropertiesBasedTcpOptionFactory();

    private PropertiesBasedTcpOptionFactory() {
    }

    public static PropertiesBasedTcpOptionFactory getInstance() {
        return INSTANCE;
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, TcpOptionKind number) {
        return this.newInstance(rawData, offset, length, this.getTargetClass(number));
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length) {
        return this.newInstance(rawData, offset, length, this.getTargetClass());
    }

    public TcpPacket.TcpOption newInstance(byte[] rawData, int offset, int length, Class<? extends TcpPacket.TcpOption> dataClass) {
        if (rawData == null || dataClass == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" dataClass: ").append(dataClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newInstance = dataClass.getMethod("newInstance", byte[].class, Integer.TYPE, Integer.TYPE);
            return (TcpPacket.TcpOption)newInstance.invoke(null, rawData, offset, length);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalTcpOption.newInstance((byte[])rawData, (int)offset, (int)length);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<? extends TcpPacket.TcpOption> getTargetClass(TcpOptionKind number) {
        if (number == null) {
            throw new NullPointerException(" number is null.");
        }
        return PacketFactoryPropertiesLoader.getInstance().getTcpOptionClass(number);
    }

    public Class<? extends TcpPacket.TcpOption> getTargetClass() {
        return PacketFactoryPropertiesLoader.getInstance().getUnknownTcpOptionClass();
    }
}

