/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory.propertiesbased;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.propertiesbased.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class PropertiesBasedPacketFactory
implements PacketFactory<Packet, NamedNumber<?, ?>> {
    private static final PropertiesBasedPacketFactory INSTANCE = new PropertiesBasedPacketFactory();

    private PropertiesBasedPacketFactory() {
    }

    public static PropertiesBasedPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, int offset, int length, NamedNumber<?, ?> number) {
        return this.newInstance(rawData, offset, length, this.getTargetClass(number));
    }

    public Packet newInstance(byte[] rawData, int offset, int length) {
        return this.newInstance(rawData, offset, length, this.getTargetClass());
    }

    public Packet newInstance(byte[] rawData, int offset, int length, Class<? extends Packet> packetClass) {
        if (rawData == null || packetClass == null) {
            StringBuilder sb = new StringBuilder(40);
            sb.append("rawData: ").append(rawData).append(" packetClass: ").append(packetClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newPacket = packetClass.getMethod("newPacket", byte[].class, Integer.TYPE, Integer.TYPE);
            return (Packet)newPacket.invoke(null, rawData, offset, length);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalPacket.newPacket((byte[])rawData, (int)offset, (int)length);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public Class<? extends Packet> getTargetClass(NamedNumber<?, ?> number) {
        if (number == null) {
            throw new NullPointerException("number is null.");
        }
        return PacketFactoryPropertiesLoader.getInstance().getPacketClass(number);
    }

    public Class<? extends Packet> getTargetClass() {
        return PacketFactoryPropertiesLoader.getInstance().getUnknownPacketClass();
    }
}

