/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pcap4j.packet.IllegalPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryPropertiesLoader;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesBasedPacketFactory
implements PacketFactory<Packet, NamedNumber<?>> {
    private static final PropertiesBasedPacketFactory INSTANCE = new PropertiesBasedPacketFactory();

    private PropertiesBasedPacketFactory() {
    }

    public static PropertiesBasedPacketFactory getInstance() {
        return INSTANCE;
    }

    public Packet newInstance(byte[] rawData, NamedNumber<?> number) {
        if (number == null) {
            throw new NullPointerException(" number: " + number);
        }
        Class<Packet> packetClass = PacketFactoryPropertiesLoader.getInstance().getPacketClass(number);
        return this.newInstance(rawData, packetClass);
    }

    public Packet newInstance(byte[] rawData) {
        Class<? extends Packet> packetClass = PacketFactoryPropertiesLoader.getInstance().getUnknownPacketClass();
        return this.newInstance(rawData, packetClass);
    }

    public Packet newInstance(byte[] rawData, Class<? extends Packet> packetClass) {
        if (rawData == null || packetClass == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("rawData: ").append(rawData).append(" packetClass: ").append(packetClass);
            throw new NullPointerException(sb.toString());
        }
        try {
            Method newPacket = packetClass.getMethod("newPacket", byte[].class);
            return (Packet)newPacket.invoke(null, new Object[]{rawData});
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IllegalRawDataException) {
                return IllegalPacket.newPacket((byte[])rawData);
            }
            throw new IllegalStateException(e);
        }
    }
}

