/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4TosPrecedence;

public final class IpV4Rfc791Tos
implements IpV4Packet.IpV4Tos {
    private static final long serialVersionUID = 1760697525836662144L;
    private final IpV4TosPrecedence precedence;
    private final boolean lowDelay;
    private final boolean highThroughput;
    private final boolean highReliability;
    private final boolean seventhBit;
    private final boolean eighthBit;

    public static IpV4Rfc791Tos newInstance(byte value) {
        return new IpV4Rfc791Tos(value);
    }

    private IpV4Rfc791Tos(byte value) {
        this.precedence = IpV4TosPrecedence.getInstance((byte)((value & 0xE0) >> 5));
        this.lowDelay = (value & 0x10) != 0;
        this.highThroughput = (value & 8) != 0;
        this.highReliability = (value & 4) != 0;
        this.seventhBit = (value & 2) != 0;
        this.eighthBit = (value & 1) != 0;
    }

    private IpV4Rfc791Tos(Builder builder) {
        if (builder == null || builder.precedence == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder).append(" builder.precedence: ").append(builder.precedence);
            throw new NullPointerException(sb.toString());
        }
        this.precedence = builder.precedence;
        this.lowDelay = builder.lowDelay;
        this.highThroughput = builder.highThroughput;
        this.highReliability = builder.highReliability;
        this.seventhBit = builder.seventhBit;
        this.eighthBit = builder.eighthBit;
    }

    public IpV4TosPrecedence getPrecedence() {
        return this.precedence;
    }

    public boolean isLowDelay() {
        return this.lowDelay;
    }

    public boolean isHighThroughput() {
        return this.highThroughput;
    }

    public boolean isHighReliability() {
        return this.highReliability;
    }

    public boolean getSeventhBit() {
        return this.seventhBit;
    }

    public boolean getEighthBit() {
        return this.eighthBit;
    }

    @Override
    public byte value() {
        byte value = (byte)((Byte)this.precedence.value() << 5);
        if (this.lowDelay) {
            value = (byte)(value | 0x10);
        }
        if (this.highThroughput) {
            value = (byte)(value | 8);
        }
        if (this.highReliability) {
            value = (byte)(value | 4);
        }
        if (this.seventhBit) {
            value = (byte)(value | 2);
        }
        if (this.eighthBit) {
            value = (byte)(value | 1);
        }
        return value;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[precedence: ").append(this.precedence).append("] [lowDelay: ").append(this.lowDelay).append("] [highThroughput: ").append(this.highThroughput).append("] [highReliability: ").append(this.highReliability).append("] [seventhBit: ").append(this.seventhBit ? 1 : 0).append("] [eighthBit: ").append(this.eighthBit ? 1 : 0).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return ((IpV4Rfc791Tos)this.getClass().cast(obj)).value() == this.value();
    }

    public int hashCode() {
        return this.value();
    }

    public static final class Builder {
        private IpV4TosPrecedence precedence;
        private boolean lowDelay;
        private boolean highThroughput;
        private boolean highReliability;
        private boolean seventhBit;
        private boolean eighthBit;

        public Builder() {
        }

        private Builder(IpV4Rfc791Tos tos) {
            this.precedence = tos.precedence;
            this.lowDelay = tos.lowDelay;
            this.highThroughput = tos.highThroughput;
            this.highReliability = tos.highReliability;
            this.seventhBit = tos.seventhBit;
            this.eighthBit = tos.eighthBit;
        }

        public Builder precedence(IpV4TosPrecedence precedence) {
            this.precedence = precedence;
            return this;
        }

        public Builder lowDelay(boolean lowDelay) {
            this.lowDelay = lowDelay;
            return this;
        }

        public Builder highThroughput(boolean highThroughput) {
            this.highThroughput = highThroughput;
            return this;
        }

        public Builder highReliability(boolean highRelibility) {
            this.highReliability = highRelibility;
            return this;
        }

        public Builder seventhBit(boolean seventhBit) {
            this.seventhBit = seventhBit;
            return this;
        }

        public Builder eighthBit(boolean eighthBit) {
            this.eighthBit = eighthBit;
            return this;
        }

        public IpV4Rfc791Tos build() {
            return new IpV4Rfc791Tos(this);
        }
    }
}

