/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataHolder;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class IllegalRadiotapData
implements RadiotapPacket.RadiotapData,
IllegalRawDataHolder {
    private static final long serialVersionUID = -707921517685565944L;
    private final byte[] rawData;
    private final IllegalRawDataException cause;

    public static IllegalRadiotapData newInstance(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null.");
        }
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalRadiotapData(rawData, offset, length, cause);
    }

    private IllegalRadiotapData(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        this.rawData = ByteArrays.getSubArray(rawData, offset, length);
        this.cause = cause;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.clone(this.rawData);
    }

    @Override
    public IllegalRawDataException getCause() {
        return this.cause;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Illegal Data: ").append(ls).append(indent).append("  data: ").append(ByteArrays.toHexString(this.rawData, "")).append(ls).append(indent).append("  cause: ").append(this.cause).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cause.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalRadiotapData other = (IllegalRadiotapData)obj;
        if (!this.cause.equals(other.cause)) {
            return false;
        }
        return Arrays.equals(this.rawData, other.rawData);
    }
}

