/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.DnsResourceRecord;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class DnsRDataPtr
implements DnsResourceRecord.DnsRData {
    private static final long serialVersionUID = 3845617703457911405L;
    private final DnsDomainName ptrDName;

    public static DnsRDataPtr newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsRDataPtr(rawData, offset, length);
    }

    private DnsRDataPtr(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.ptrDName = DnsDomainName.newInstance(rawData, offset, length);
    }

    private DnsRDataPtr(Builder builder) {
        if (builder == null || builder.ptrDName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.ptrDName: ").append(builder.ptrDName);
            throw new NullPointerException(sb.toString());
        }
        this.ptrDName = builder.ptrDName;
    }

    public DnsDomainName getPtrDName() {
        return this.ptrDName;
    }

    @Override
    public int length() {
        return this.ptrDName.length();
    }

    @Override
    public byte[] getRawData() {
        return this.ptrDName.getRawData();
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.convertToString("", null);
    }

    @Override
    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    @Override
    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("PTR RDATA:").append(ls).append(indent).append("  PTRDNAME: ").append(this.ptrDName.toString(headerRawData)).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.ptrDName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        DnsRDataPtr other = (DnsRDataPtr)obj;
        return this.ptrDName.equals(other.ptrDName);
    }

    public static final class Builder {
        private DnsDomainName ptrDName;

        public Builder() {
        }

        private Builder(DnsRDataPtr obj) {
            this.ptrDName = obj.ptrDName;
        }

        public Builder ptrDName(DnsDomainName ptrDName) {
            this.ptrDName = ptrDName;
            return this;
        }

        public DnsRDataPtr build() {
            return new DnsRDataPtr(this);
        }
    }
}

