/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.time.Instant;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapDumper
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PcapDumper.class);
    private final Pointer dumper;
    private final PcapHandle.TimestampPrecision timestampPrecision;
    private final ReentrantReadWriteLock dumperLock = new ReentrantReadWriteLock(true);
    private volatile boolean open = true;

    PcapDumper(Pointer dumper, PcapHandle.TimestampPrecision timestampPrecision) {
        this.timestampPrecision = timestampPrecision;
        this.dumper = dumper;
    }

    Pointer getDumper() {
        return this.dumper;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void dump(Packet packet) throws NotOpenException {
        this.dump(packet, Instant.now());
    }

    public void dump(PcapPacket packet) throws NotOpenException {
        this.dump(packet, packet.getTimestamp());
    }

    public void dump(Packet packet, Instant timestamp) throws NotOpenException {
        if (packet == null || timestamp == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("packet: ").append(packet).append(" ts: ").append(timestamp);
            throw new NullPointerException(sb.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dumping a packet: " + packet);
        }
        this.dumpRaw(packet.getRawData(), timestamp);
    }

    public void dumpRaw(byte[] packet) throws NotOpenException {
        this.dumpRaw(packet, Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpRaw(byte[] packet, Instant timestamp) throws NotOpenException {
        if (packet == null || timestamp == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("packet: ").append(packet).append(" timestamp: ").append(timestamp);
            throw new NullPointerException(sb.toString());
        }
        if (!this.open) {
            throw new NotOpenException();
        }
        NativeMappings.pcap_pkthdr header = new NativeMappings.pcap_pkthdr();
        header.len = header.caplen = packet.length;
        header.ts = new NativeMappings.timeval();
        header.ts.tv_sec = new NativeLong(timestamp.getEpochSecond());
        switch (this.timestampPrecision) {
            case MICRO: {
                header.ts.tv_usec = new NativeLong((long)timestamp.getNano() / 1000L);
                break;
            }
            case NANO: {
                header.ts.tv_usec = new NativeLong((long)timestamp.getNano());
                break;
            }
            default: {
                throw new AssertionError((Object)"Never get here.");
            }
        }
        if (!this.dumperLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            NativeMappings.pcap_dump(this.dumper, header, packet);
        }
        finally {
            this.dumperLock.readLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dumped a packet: " + ByteArrays.toHexString(packet, " "));
        }
    }

    public void flush() throws PcapNativeException, NotOpenException {
        int rc;
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.dumperLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            rc = NativeMappings.pcap_dump_flush(this.dumper);
        }
        finally {
            this.dumperLock.readLock().unlock();
        }
        if (rc < 0) {
            throw new PcapNativeException("Failed to flush.", rc);
        }
    }

    public long ftell() throws PcapNativeException, NotOpenException {
        NativeLong nposition;
        if (!this.open) {
            throw new NotOpenException();
        }
        if (!this.dumperLock.readLock().tryLock()) {
            throw new NotOpenException();
        }
        try {
            if (!this.open) {
                throw new NotOpenException();
            }
            nposition = NativeMappings.pcap_dump_ftell(this.dumper);
        }
        finally {
            this.dumperLock.readLock().unlock();
        }
        long position = nposition.longValue();
        if (position < 0L) {
            throw new PcapNativeException("Failed to get the file position.");
        }
        return position;
    }

    @Override
    public void close() {
        if (!this.open) {
            logger.warn("Already closed.");
            return;
        }
        this.dumperLock.writeLock().lock();
        try {
            if (!this.open) {
                logger.warn("Already closed.");
                return;
            }
            this.open = false;
        }
        finally {
            this.dumperLock.writeLock().unlock();
        }
        NativeMappings.pcap_dump_close(this.dumper);
        logger.info("Closed.");
    }
}

