/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataHolder;
import org.pcap4j.packet.SctpPacket;
import org.pcap4j.packet.namednumber.SctpChunkType;
import org.pcap4j.util.ByteArrays;

public final class IllegalSctpChunk
implements SctpPacket.SctpChunk,
IllegalRawDataHolder {
    private static final long serialVersionUID = 379650793871792784L;
    private final SctpChunkType type;
    private final byte[] rawData;
    private final IllegalRawDataException cause;

    public static IllegalSctpChunk newInstance(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        if (cause == null) {
            throw new NullPointerException("cause is null.");
        }
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalSctpChunk(rawData, offset, length, cause);
    }

    private IllegalSctpChunk(byte[] rawData, int offset, int length, IllegalRawDataException cause) {
        this.type = SctpChunkType.getInstance(rawData[offset]);
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
        this.cause = cause;
    }

    @Override
    public SctpChunkType getType() {
        return this.type;
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public IllegalRawDataException getCause() {
        return this.cause;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.type);
        sb.append(", Illegal Raw Data: 0x").append(ByteArrays.toHexString(this.rawData, ""));
        sb.append(", Cause: ").append(this.cause);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cause.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalSctpChunk other = (IllegalSctpChunk)obj;
        if (!this.cause.equals(other.cause)) {
            return false;
        }
        return Arrays.equals(this.rawData, other.rawData);
    }
}

