/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.GtpV1Packet;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class GtpSelector
extends AbstractPacket {
    private static final long serialVersionUID = 5081921978086270980L;

    public static Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        int ver = rawData[offset] >> 5 & 7;
        GtpV1Packet.ProtocolType pt = GtpV1Packet.ProtocolType.getInstance((rawData[offset] & 0x10) != 0);
        switch (ver) {
            case 1: {
                switch (pt) {
                    case GTP: {
                        return GtpV1Packet.newPacket(rawData, offset, length);
                    }
                }
                return (Packet)PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset, length, new NotApplicable[]{NotApplicable.UNKNOWN});
            }
        }
        return (Packet)PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset, length, new NotApplicable[]{NotApplicable.UNKNOWN});
    }

    private GtpSelector() {
        throw new AssertionError();
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }
}

