/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.Oui;
import org.pcap4j.util.ByteArrays;

public final class SnapPacket
extends AbstractPacket {
    private static final long serialVersionUID = 2957315717350800697L;
    private final SnapHeader header;
    private final Packet payload;

    public static SnapPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new SnapPacket(rawData, offset, length);
    }

    private SnapPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new SnapHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? (Packet)PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, offset + this.header.length(), payloadLength, new EtherType[]{this.header.getProtocolId()}) : null;
    }

    private SnapPacket(Builder builder) {
        if (builder == null || builder.oui == null || builder.protocolId == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.oui: ").append(builder.oui).append(" builder.protocolId: ").append(builder.protocolId);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new SnapHeader(builder);
    }

    @Override
    public SnapHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class SnapHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8525438913079396866L;
        private static final int OUI_OFFSET = 0;
        private static final int OUI_SIZE = 3;
        private static final int PROTOCOL_ID_OFFSET = 3;
        private static final int PROTOCOL_ID_SIZE = 2;
        private static final int SNAP_HEADER_SIZE = 5;
        private final Oui oui;
        private final EtherType protocolId;

        private SnapHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 5) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a SNAP header(").append(5).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.oui = Oui.getInstance(ByteArrays.getSubArray(rawData, offset + 0, 3));
            this.protocolId = EtherType.getInstance(ByteArrays.getShort(rawData, offset + 3));
        }

        private SnapHeader(Builder builder) {
            this.oui = builder.oui;
            this.protocolId = builder.protocolId;
        }

        public Oui getOui() {
            return this.oui;
        }

        public EtherType getProtocolId() {
            return this.protocolId;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(this.oui.valueAsByteArray());
            rawFields.add(ByteArrays.toByteArray((Short)this.protocolId.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 5;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[Subnetwork Access Protocol header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  OUI: ").append(this.oui).append(ls);
            sb.append("  Protocol ID: ").append(this.protocolId).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            SnapHeader other = (SnapHeader)obj;
            return this.oui.equals(other.oui) && this.protocolId.equals(other.protocolId);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.oui.hashCode();
            result = 31 * result + this.protocolId.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Oui oui;
        private EtherType protocolId;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(SnapPacket packet) {
            this.oui = packet.header.oui;
            this.protocolId = packet.header.protocolId;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder oui(Oui oui) {
            this.oui = oui;
            return this;
        }

        public Builder protocolId(EtherType protocolId) {
            this.protocolId = protocolId;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public SnapPacket build() {
            return new SnapPacket(this);
        }
    }
}

