/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.util.LazyValue;

public final class PcapPacket
extends AbstractPacket {
    private static final long serialVersionUID = -5252229699437537792L;
    private final byte[] rawData;
    private final Instant timestamp;
    private final int originalLength;
    private final LazyValue<Packet> packet;

    PcapPacket(byte[] rawData, DataLinkType dlt, Instant timestamp, int originalLength) {
        this.rawData = rawData;
        this.timestamp = timestamp;
        this.originalLength = originalLength;
        this.packet = new LazyValue<Packet>(() -> (Packet)PacketFactories.getFactory(Packet.class, DataLinkType.class).newInstance(rawData, 0, rawData.length, new DataLinkType[]{dlt}));
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    public Packet getPacket() {
        return this.packet.getValue();
    }

    @Override
    public Packet getPayload() {
        return this.packet.getValue();
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public Packet.Builder getBuilder() {
        return this.packet.getValue().getBuilder();
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append("Captured at: ").append(ZonedDateTime.ofInstant(this.timestamp, ZoneId.systemDefault())).append(ls).append("Original length: ").append(this.originalLength).append(" bytes").append(ls).append(this.packet.getValue());
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PcapPacket packets = (PcapPacket)o;
        if (this.originalLength != packets.originalLength) {
            return false;
        }
        if (!Arrays.equals(this.rawData, packets.rawData)) {
            return false;
        }
        return this.timestamp.equals(packets.timestamp);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.rawData);
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.originalLength;
        return result;
    }
}

