/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2BinaryPacket
extends AbstractPacket {
    private static final long serialVersionUID = 6484755289384336675L;
    private final Ssh2BinaryHeader header;
    private final Packet payload;
    private final byte[] randomPadding;
    private final byte[] mac;

    public static Ssh2BinaryPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2BinaryPacket(rawData, offset, length);
    }

    private Ssh2BinaryPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2BinaryHeader(rawData, offset, length);
        int payloadLength = this.header.getPacketLength() - this.header.getPaddingLengthAsInt() - 1;
        if (payloadLength < 0 || payloadLength > length - 5) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("rawData is too short. rawData length: ").append(length).append(", header.getPacketLength(): ").append(this.header.getPacketLength()).append(", header.getPaddingLengthAsInt(): ").append(this.header.getPaddingLengthAsInt());
            throw new IllegalRawDataException(sb.toString());
        }
        int payloadOffset = 5 + offset;
        this.payload = payloadLength > 0 ? (Packet)PacketFactories.getFactory(Packet.class, Ssh2MessageNumber.class).newInstance(rawData, payloadOffset, payloadLength, new Ssh2MessageNumber[]{Ssh2MessageNumber.getInstance(rawData[payloadOffset])}) : null;
        try {
            this.randomPadding = ByteArrays.getSubArray(rawData, payloadOffset + payloadLength, this.header.getPaddingLength());
            this.mac = ByteArrays.getSubArray(rawData, payloadOffset + payloadLength + this.randomPadding.length);
        }
        catch (Exception e) {
            throw new IllegalRawDataException(e);
        }
    }

    private Ssh2BinaryPacket(Builder builder) {
        int payloadLength;
        if (builder == null || builder.randomPadding == null || builder.mac == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.randomPadding: ").append(builder.randomPadding).append(" builder.mac: ").append(builder.mac);
            throw new NullPointerException(sb.toString());
        }
        if (!builder.paddingAtBuild && builder.randomPadding == null) {
            throw new NullPointerException("builder.randomPadding must not be null if builder.paddingAtBuild is false");
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        int n = payloadLength = this.payload != null ? this.payload.length() : 0;
        if (builder.paddingAtBuild) {
            int blockSize = builder.cipherBlockSize > 8 ? builder.cipherBlockSize : 8;
            int paddingSize = payloadLength % blockSize;
            this.randomPadding = new byte[paddingSize];
        } else {
            this.randomPadding = new byte[builder.randomPadding.length];
            System.arraycopy(builder.randomPadding, 0, this.randomPadding, 0, builder.randomPadding.length);
        }
        this.header = new Ssh2BinaryHeader(builder, payloadLength, (byte)this.randomPadding.length);
        this.mac = new byte[builder.mac.length];
        System.arraycopy(builder.mac, 0, this.mac, 0, builder.mac.length);
    }

    @Override
    public Ssh2BinaryHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public byte[] getRandomPadding() {
        byte[] copy = new byte[this.randomPadding.length];
        System.arraycopy(this.randomPadding, 0, copy, 0, this.randomPadding.length);
        return copy;
    }

    public byte[] getMac() {
        byte[] copy = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, copy, 0, this.mac.length);
        return copy;
    }

    @Override
    protected int calcLength() {
        int length = super.calcLength();
        length += this.randomPadding.length;
        return length += this.mac.length;
    }

    @Override
    protected byte[] buildRawData() {
        byte[] rawData = super.buildRawData();
        if (this.randomPadding.length != 0) {
            System.arraycopy(this.randomPadding, 0, rawData, rawData.length - this.randomPadding.length - this.mac.length, this.randomPadding.length);
        }
        if (this.mac.length != 0) {
            System.arraycopy(this.mac, 0, rawData, rawData.length - this.mac.length, this.mac.length);
        }
        return rawData;
    }

    @Override
    protected String buildString() {
        String ls;
        StringBuilder sb = new StringBuilder();
        sb.append(this.header.toString());
        if (this.payload != null) {
            sb.append(this.payload.toString());
        }
        if (this.randomPadding.length != 0) {
            ls = System.getProperty("line.separator");
            sb.append("[random padding (").append(this.randomPadding.length).append(" bytes)]").append(ls).append("  Hex stream: ").append(ByteArrays.toHexString(this.randomPadding, " ")).append(ls);
        }
        if (this.mac.length != 0) {
            ls = System.getProperty("line.separator");
            sb.append("[mac (").append(this.mac.length).append(" bytes)]").append(ls).append("  Hex stream: ").append(ByteArrays.toHexString(this.mac, " ")).append(ls);
        }
        return sb.toString();
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Ssh2BinaryPacket other = (Ssh2BinaryPacket)obj;
            return Arrays.equals(this.randomPadding, other.randomPadding) && Arrays.equals(this.mac, other.mac);
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        int result = super.calcHashCode();
        result = 31 * result + Arrays.hashCode(this.randomPadding);
        result = 31 * result + Arrays.hashCode(this.mac);
        return result;
    }

    public static final class Ssh2BinaryHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -7927092563030949527L;
        private static final int PACKET_LENGTH_OFFSET = 0;
        private static final int PACKET_LENGTH_SIZE = 4;
        private static final int PADDING_LENGTH_OFFSET = 4;
        private static final int PADDING_LENGTH_SIZE = 1;
        private static final int SSH2_BINARY_HEADER_SIZE = 5;
        private final int packetLength;
        private final byte paddingLength;

        private Ssh2BinaryHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 5) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("The data is too short to build an SSH2 Binary header(").append(5).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.packetLength = ByteArrays.getInt(rawData, 0 + offset);
            this.paddingLength = ByteArrays.getByte(rawData, 4 + offset);
            if (this.packetLength < 0) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The packet length which is longer than 2147483647 is not supported. packet length: ").append(this.getPacketLengthAsLong());
                throw new IllegalRawDataException(sb.toString());
            }
        }

        private Ssh2BinaryHeader(Builder builder, int payloadLength, byte paddingLength) {
            if (builder.correctLengthAtBuild) {
                this.packetLength = payloadLength;
                this.paddingLength = paddingLength;
            } else {
                this.packetLength = builder.packetLength;
                this.paddingLength = builder.paddingLength;
            }
            if (this.packetLength < 0) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The packet length which is longer than 2147483647 is not supported. packet length: ").append((long)builder.packetLength & 0xFFFFFFFFL);
                throw new IllegalArgumentException(sb.toString());
            }
        }

        public int getPacketLength() {
            return this.packetLength;
        }

        public long getPacketLengthAsLong() {
            return 0xFFFFFFFFL & (long)this.packetLength;
        }

        public byte getPaddingLength() {
            return this.paddingLength;
        }

        public int getPaddingLengthAsInt() {
            return 0xFF & this.paddingLength;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.packetLength));
            rawFields.add(ByteArrays.toByteArray(this.paddingLength));
            return rawFields;
        }

        @Override
        public int length() {
            return 5;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Binary Packet Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  packet_length: ").append(this.packetLength).append(ls);
            sb.append("  padding_length: ").append(this.paddingLength).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            Ssh2BinaryHeader other = (Ssh2BinaryHeader)obj;
            return this.packetLength == other.packetLength && this.paddingLength == other.paddingLength;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.packetLength;
            result = 31 * result + this.paddingLength;
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<Ssh2BinaryPacket> {
        private int packetLength;
        private byte paddingLength;
        private Packet.Builder payloadBuilder;
        private byte[] randomPadding;
        private byte[] mac;
        private boolean correctLengthAtBuild;
        private int cipherBlockSize = 0;
        private boolean paddingAtBuild;

        public Builder() {
        }

        private Builder(Ssh2BinaryPacket packet) {
            this.packetLength = packet.header.packetLength;
            this.paddingLength = packet.header.paddingLength;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
            this.randomPadding = packet.randomPadding;
            this.mac = packet.mac;
        }

        public Builder packetLength(int packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public Builder paddingLength(byte paddingLength) {
            this.paddingLength = paddingLength;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder randomPadding(byte[] randomPadding) {
            this.randomPadding = randomPadding;
            return this;
        }

        public Builder mac(byte[] mac) {
            this.mac = mac;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        public Builder cipherBlockSize(int cipherBlockSize) {
            this.cipherBlockSize = cipherBlockSize;
            return this;
        }

        public Builder paddingAtBuild(boolean paddingAtBuild) {
            this.paddingAtBuild = paddingAtBuild;
            return this;
        }

        @Override
        public Ssh2BinaryPacket build() {
            return new Ssh2BinaryPacket(this);
        }
    }
}

