/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IllegalRawDataPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.UnknownIpV6Extension;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtUnknownPacket
extends AbstractPacket {
    private static final long serialVersionUID = -7055290165058067091L;
    private final IpV6ExtUnknownHeader header;
    private final Packet payload;

    public static IpV6ExtUnknownPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV6ExtUnknownPacket(rawData, offset, length);
    }

    private IpV6ExtUnknownPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IpV6ExtUnknownHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        if (payloadLength > 0) {
            PacketFactory<Packet, IpNumber> factory = PacketFactories.getFactory(Packet.class, IpNumber.class);
            Packet nextPacket = (Packet)factory.newInstance(rawData, offset + this.header.length(), payloadLength, new IpNumber[]{this.header.getNextHeader(), UnknownIpV6Extension.getInstance()});
            if (nextPacket instanceof IllegalRawDataPacket) {
                nextPacket = (Packet)factory.newInstance(rawData, offset + this.header.length(), payloadLength, new IpNumber[0]);
            }
            this.payload = nextPacket;
        } else {
            this.payload = null;
        }
    }

    private IpV6ExtUnknownPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null || builder.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV6ExtUnknownHeader(builder);
    }

    @Override
    public IpV6ExtUnknownHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IpV6ExtUnknownHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -4314577591889991355L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int DATA_OFFSET = 2;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final byte[] data;

        private IpV6ExtUnknownHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data length of this header is must be more than 3. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1 + offset);
            int headerLength = (this.getHdrExtLenAsInt() + 1) * 8;
            if (length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build this header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.data = ByteArrays.getSubArray(rawData, 2 + offset, headerLength - 2);
        }

        private IpV6ExtUnknownHeader(Builder builder) {
            if (builder.data.length < 6) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("data length must be more than 5. data: ").append(ByteArrays.toHexString(builder.data, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            if ((builder.data.length + 2) % 8 != 0) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("(builder.data.length + 2) % 8 must be 0. data: ").append(builder.data);
                throw new IllegalArgumentException(sb.toString());
            }
            this.nextHeader = builder.nextHeader;
            this.data = ByteArrays.clone(builder.data);
            this.hdrExtLen = builder.correctLengthAtBuild ? (byte)((this.data.length + 2) / 8 - 1) : builder.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public byte[] getData() {
            return ByteArrays.clone(this.data);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            rawFields.add(this.getData());
            return rawFields;
        }

        @Override
        public int calcLength() {
            return this.data.length + 2;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv6 Unknown Extension Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls);
            sb.append("  data: ").append(ByteArrays.toHexString(this.data, " ")).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV6ExtUnknownHeader other = (IpV6ExtUnknownHeader)obj;
            return this.nextHeader.equals(other.nextHeader) && this.hdrExtLen == other.hdrExtLen && Arrays.equals(this.data, other.data);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.nextHeader.hashCode();
            result = 31 * result + this.hdrExtLen;
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtUnknownPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private byte[] data;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        public Builder(IpV6ExtUnknownPacket packet) {
            this.nextHeader = packet.header.nextHeader;
            this.hdrExtLen = packet.header.hdrExtLen;
            this.data = packet.header.data;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public IpV6ExtUnknownPacket build() {
            return new IpV6ExtUnknownPacket(this);
        }
    }
}

