/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryBinder;
import org.pcap4j.packet.factory.PacketFactoryBinderProvider;
import org.pcap4j.packet.factory.SimplePacketFactoryBinder;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PacketFactories {
    private static final Logger logger = LoggerFactory.getLogger(PacketFactories.class);
    private static final PacketFactoryBinder FACTORY_BINDER;

    private PacketFactories() {
        throw new AssertionError();
    }

    public static <T, N extends NamedNumber<?, ?>> PacketFactory<T, N> getFactory(Class<T> targetClass, Class<N> numberClass) {
        if (numberClass == null || targetClass == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("numberClass: ").append(numberClass).append(" targetClass: ").append(targetClass);
            throw new NullPointerException(sb.toString());
        }
        if (FACTORY_BINDER != null) {
            return FACTORY_BINDER.getPacketFactory(targetClass, numberClass);
        }
        return SimplePacketFactoryBinder.getInstance().getPacketFactory(targetClass, numberClass);
    }

    static {
        PacketFactoryBinder factoryBinder = null;
        try {
            ServiceLoader<PacketFactoryBinderProvider> loader = ServiceLoader.load(PacketFactoryBinderProvider.class);
            Iterator<PacketFactoryBinderProvider> iter = loader.iterator();
            if (iter.hasNext()) {
                PacketFactoryBinderProvider packetFactoryBinderProvider = iter.next();
                logger.info("A PacketFactoryBinderProvider implementation is found. ClassLoader: {}, URL: {}", (Object)packetFactoryBinderProvider.getClass().getClassLoader().toString(), (Object)packetFactoryBinderProvider.getClass().getProtectionDomain().getCodeSource().getLocation());
                factoryBinder = packetFactoryBinderProvider.getBinder();
                logger.info("Succeeded in PacketFactoryBinderProvider.getBinder()");
            } else {
                logger.warn("No PacketFactoryBinder is available. All packets will be captured as UnknownPacket.");
            }
        }
        catch (ServiceConfigurationError e) {
            logger.warn(e.getClass().getName() + ": " + e.getMessage());
        }
        FACTORY_BINDER = factoryBinder;
    }
}

