/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.TransportPacket;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.packet.namednumber.TcpPort;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpPacket
extends AbstractPacket
implements TransportPacket {
    private static final long serialVersionUID = 7904566782140471299L;
    private final TcpHeader header;
    private final Packet payload;

    public static TcpPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new TcpPacket(rawData, offset, length);
    }

    private TcpPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new TcpHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        if (payloadLength > 0) {
            PacketFactory<Packet, TcpPort> factory = PacketFactories.getFactory(Packet.class, TcpPort.class);
            Class<Packet> class4UnknownPort = factory.getTargetClass();
            Class<Packet> class4DstPort = factory.getTargetClass(this.header.getDstPort());
            TcpPort serverPort = class4DstPort.equals(class4UnknownPort) ? this.header.getSrcPort() : this.header.getDstPort();
            this.payload = PacketFactories.getFactory(Packet.class, TcpPort.class).newInstance(rawData, offset + this.header.length(), payloadLength, serverPort);
        } else {
            this.payload = null;
        }
    }

    private TcpPacket(Builder builder) {
        if (builder == null || builder.srcPort == null || builder.dstPort == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.srcPort: ").append(builder.srcPort).append(" builder.dstPort: ").append(builder.dstPort);
            throw new NullPointerException(sb.toString());
        }
        if (builder.correctChecksumAtBuild) {
            if (builder.srcAddr == null || builder.dstAddr == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
                throw new NullPointerException(sb.toString());
            }
            if (!builder.srcAddr.getClass().isInstance(builder.dstAddr)) {
                StringBuilder sb = new StringBuilder();
                sb.append("builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
                throw new IllegalArgumentException(sb.toString());
            }
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new TcpHeader(builder, this.payload != null ? this.payload.getRawData() : new byte[]{});
    }

    @Override
    public TcpHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public boolean hasValidChecksum(InetAddress srcAddr, InetAddress dstAddr, boolean acceptZero) {
        if (srcAddr == null || dstAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new NullPointerException(sb.toString());
        }
        if (!srcAddr.getClass().isInstance(dstAddr)) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new IllegalArgumentException(sb.toString());
        }
        byte[] payloadData = this.payload != null ? this.payload.getRawData() : new byte[]{};
        short calculatedChecksum = this.header.calcChecksum(srcAddr, dstAddr, this.header.getRawData(), payloadData);
        if (calculatedChecksum == 0) {
            return true;
        }
        return this.header.checksum == 0 && acceptZero;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface TcpOption
    extends Serializable {
        public TcpOptionKind getKind();

        public int length();

        public byte[] getRawData();
    }

    public static final class TcpHeader
    extends AbstractPacket.AbstractHeader
    implements TransportPacket.TransportHeader {
        private static final Logger logger = LoggerFactory.getLogger(TcpHeader.class);
        private static final long serialVersionUID = -795185420055823677L;
        private static final int SRC_PORT_OFFSET = 0;
        private static final int SRC_PORT_SIZE = 2;
        private static final int DST_PORT_OFFSET = 2;
        private static final int DST_PORT_SIZE = 2;
        private static final int SEQUENCE_NUMBER_OFFSET = 4;
        private static final int SEQUENCE_NUMBER_SIZE = 4;
        private static final int ACKNOWLEDGMENT_NUMBER_OFFSET = 8;
        private static final int ACKNOWLEDGMENT_NUMBER_SIZE = 4;
        private static final int DATA_OFFSET_AND_RESERVED_AND_CONTROL_BITS_OFFSET = 12;
        private static final int DATA_OFFSET_AND_RESERVED_AND_CONTROL_BITS_SIZE = 2;
        private static final int WINDOW_OFFSET = 14;
        private static final int WINDOW_SIZE = 2;
        private static final int CHECKSUM_OFFSET = 16;
        private static final int CHECKSUM_SIZE = 2;
        private static final int URGENT_POINTER_OFFSET = 18;
        private static final int URGENT_POINTER_SIZE = 2;
        private static final int OPTIONS_OFFSET = 20;
        private static final int MIN_TCP_HEADER_SIZE = 20;
        private static final int IPV4_PSEUDO_HEADER_SIZE = 12;
        private static final int IPV6_PSEUDO_HEADER_SIZE = 40;
        private final TcpPort srcPort;
        private final TcpPort dstPort;
        private final int sequenceNumber;
        private final int acknowledgmentNumber;
        private final byte dataOffset;
        private final byte reserved;
        private final boolean urg;
        private final boolean ack;
        private final boolean psh;
        private final boolean rst;
        private final boolean syn;
        private final boolean fin;
        private final short window;
        private final short checksum;
        private final short urgentPointer;
        private final List<TcpOption> options;
        private final byte[] padding;

        private TcpHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            int currentOffsetInHeader;
            if (length < 20) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build this header(").append(20).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.srcPort = TcpPort.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.dstPort = TcpPort.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.sequenceNumber = ByteArrays.getInt(rawData, 4 + offset);
            this.acknowledgmentNumber = ByteArrays.getInt(rawData, 8 + offset);
            short dataOffsetAndReservedAndControlBits = ByteArrays.getShort(rawData, 12 + offset);
            this.dataOffset = (byte)((dataOffsetAndReservedAndControlBits & 0xF000) >> 12);
            this.reserved = (byte)((dataOffsetAndReservedAndControlBits & 0xFC0) >> 6);
            this.urg = (dataOffsetAndReservedAndControlBits & 0x20) != 0;
            this.ack = (dataOffsetAndReservedAndControlBits & 0x10) != 0;
            this.psh = (dataOffsetAndReservedAndControlBits & 8) != 0;
            this.rst = (dataOffsetAndReservedAndControlBits & 4) != 0;
            this.syn = (dataOffsetAndReservedAndControlBits & 2) != 0;
            this.fin = (dataOffsetAndReservedAndControlBits & 1) != 0;
            this.window = ByteArrays.getShort(rawData, 14 + offset);
            this.checksum = ByteArrays.getShort(rawData, 16 + offset);
            this.urgentPointer = ByteArrays.getShort(rawData, 18 + offset);
            int headerLength = this.getDataOffsetAsInt() * 4;
            if (length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build this header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (headerLength < 20) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("The data offset must be equal or more than ").append(5).append(", but it is: ").append(this.getDataOffsetAsInt());
                throw new IllegalRawDataException(sb.toString());
            }
            this.options = new ArrayList<TcpOption>();
            try {
                TcpOption newOne;
                for (currentOffsetInHeader = 20; currentOffsetInHeader < headerLength; currentOffsetInHeader += newOne.length()) {
                    TcpOptionKind kind = TcpOptionKind.getInstance(rawData[currentOffsetInHeader + offset]);
                    newOne = PacketFactories.getFactory(TcpOption.class, TcpOptionKind.class).newInstance(rawData, currentOffsetInHeader + offset, headerLength - currentOffsetInHeader, kind);
                    this.options.add(newOne);
                    if (!newOne.getKind().equals(TcpOptionKind.END_OF_OPTION_LIST)) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred during analyzing TCP options: ", (Throwable)e);
            }
            int paddingLength = headerLength - currentOffsetInHeader;
            this.padding = paddingLength != 0 ? ByteArrays.getSubArray(rawData, currentOffsetInHeader + offset, paddingLength) : new byte[0];
        }

        private TcpHeader(Builder builder, byte[] payload) {
            if ((builder.reserved & 0xC0) != 0) {
                throw new IllegalArgumentException("Invalid reserved: " + builder.reserved);
            }
            this.srcPort = builder.srcPort;
            this.dstPort = builder.dstPort;
            this.sequenceNumber = builder.sequenceNumber;
            this.acknowledgmentNumber = builder.acknowledgmentNumber;
            this.reserved = builder.reserved;
            this.urg = builder.urg;
            this.ack = builder.ack;
            this.psh = builder.psh;
            this.rst = builder.rst;
            this.syn = builder.syn;
            this.fin = builder.fin;
            this.window = builder.window;
            this.urgentPointer = builder.urgentPointer;
            this.options = builder.options != null ? new ArrayList<TcpOption>(builder.options) : new ArrayList<TcpOption>(0);
            if (builder.paddingAtBuild) {
                int mod = this.measureLengthWithoutPadding() % 4;
                this.padding = mod != 0 ? new byte[4 - mod] : new byte[0];
            } else if (builder.padding != null) {
                this.padding = new byte[builder.padding.length];
                System.arraycopy(builder.padding, 0, this.padding, 0, this.padding.length);
            } else {
                this.padding = new byte[0];
            }
            if (builder.correctLengthAtBuild) {
                this.dataOffset = (byte)(this.length() / 4);
            } else {
                if ((builder.dataOffset & 0xF0) != 0) {
                    throw new IllegalArgumentException("Invalid dataOffset: " + builder.dataOffset);
                }
                this.dataOffset = builder.dataOffset;
            }
            this.checksum = builder.correctChecksumAtBuild ? (builder.srcAddr instanceof Inet4Address && PacketPropertiesLoader.getInstance().tcpV4CalcChecksum() || builder.srcAddr instanceof Inet6Address && PacketPropertiesLoader.getInstance().tcpV6CalcChecksum() ? this.calcChecksum(builder.srcAddr, builder.dstAddr, this.buildRawData(true), payload) : (short)0) : builder.checksum;
        }

        private short calcChecksum(InetAddress srcAddr, InetAddress dstAddr, byte[] header, byte[] payload) {
            int destPos;
            byte[] data;
            int pseudoHeaderSize;
            int totalLength = payload.length + this.length();
            boolean lowerLayerIsIpV4 = srcAddr instanceof Inet4Address;
            int n = pseudoHeaderSize = lowerLayerIsIpV4 ? 12 : 40;
            if (totalLength % 2 != 0) {
                data = new byte[totalLength + 1 + pseudoHeaderSize];
                destPos = totalLength + 1;
            } else {
                data = new byte[totalLength + pseudoHeaderSize];
                destPos = totalLength;
            }
            System.arraycopy(header, 0, data, 0, header.length);
            System.arraycopy(payload, 0, data, header.length, payload.length);
            System.arraycopy(srcAddr.getAddress(), 0, data, destPos, srcAddr.getAddress().length);
            System.arraycopy(dstAddr.getAddress(), 0, data, destPos += srcAddr.getAddress().length, dstAddr.getAddress().length);
            destPos += dstAddr.getAddress().length;
            destPos = lowerLayerIsIpV4 ? ++destPos : (destPos += 3);
            data[destPos] = (Byte)IpNumber.TCP.value();
            System.arraycopy(ByteArrays.toByteArray((short)totalLength), 0, data, ++destPos, 2);
            destPos += 2;
            return ByteArrays.calcChecksum(data);
        }

        @Override
        public TcpPort getSrcPort() {
            return this.srcPort;
        }

        @Override
        public TcpPort getDstPort() {
            return this.dstPort;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public long getSequenceNumberAsLong() {
            return (long)this.sequenceNumber & 0xFFFFFFFFL;
        }

        public int getAcknowledgmentNumber() {
            return this.acknowledgmentNumber;
        }

        public long getAcknowledgmentNumberAsLong() {
            return (long)this.acknowledgmentNumber & 0xFFFFFFFFL;
        }

        public byte getDataOffset() {
            return this.dataOffset;
        }

        public int getDataOffsetAsInt() {
            return 0xFF & this.dataOffset;
        }

        public byte getReserved() {
            return this.reserved;
        }

        public boolean getUrg() {
            return this.urg;
        }

        public boolean getAck() {
            return this.ack;
        }

        public boolean getPsh() {
            return this.psh;
        }

        public boolean getRst() {
            return this.rst;
        }

        public boolean getSyn() {
            return this.syn;
        }

        public boolean getFin() {
            return this.fin;
        }

        public short getWindow() {
            return this.window;
        }

        public int getWindowAsInt() {
            return 0xFFFF & this.window;
        }

        public short getChecksum() {
            return this.checksum;
        }

        public short getUrgentPointer() {
            return this.urgentPointer;
        }

        public int getUrgentPointerAsInt() {
            return this.urgentPointer & 0xFFFF;
        }

        public List<TcpOption> getOptions() {
            return new ArrayList<TcpOption>(this.options);
        }

        public byte[] getPadding() {
            byte[] copy = new byte[this.padding.length];
            System.arraycopy(this.padding, 0, copy, 0, this.padding.length);
            return copy;
        }

        @Override
        protected List<byte[]> getRawFields() {
            return this.getRawFields(false);
        }

        private List<byte[]> getRawFields(boolean zeroInsteadOfChecksum) {
            int flags = 0;
            if (this.fin) {
                flags = 1;
            }
            if (this.syn) {
                flags = (byte)(flags | 2);
            }
            if (this.rst) {
                flags = (byte)(flags | 4);
            }
            if (this.psh) {
                flags = (byte)(flags | 8);
            }
            if (this.ack) {
                flags = (byte)(flags | 0x10);
            }
            if (this.urg) {
                flags = (byte)(flags | 0x20);
            }
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.srcPort.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.dstPort.value()));
            rawFields.add(ByteArrays.toByteArray(this.sequenceNumber));
            rawFields.add(ByteArrays.toByteArray(this.acknowledgmentNumber));
            rawFields.add(ByteArrays.toByteArray((short)(this.dataOffset << 12 | this.reserved << 6 | flags)));
            rawFields.add(ByteArrays.toByteArray(this.window));
            rawFields.add(ByteArrays.toByteArray(zeroInsteadOfChecksum ? (short)0 : this.checksum));
            rawFields.add(ByteArrays.toByteArray(this.urgentPointer));
            for (TcpOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            rawFields.add(this.padding);
            return rawFields;
        }

        private byte[] buildRawData(boolean zeroInsteadOfChecksum) {
            return ByteArrays.concatenate(this.getRawFields(zeroInsteadOfChecksum));
        }

        private int measureLengthWithoutPadding() {
            int len = 0;
            for (TcpOption o : this.options) {
                len += o.length();
            }
            return len + 20;
        }

        @Override
        protected int calcLength() {
            return this.measureLengthWithoutPadding() + this.padding.length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[TCP Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Source port: ").append(this.getSrcPort()).append(ls);
            sb.append("  Destination port: ").append(this.getDstPort()).append(ls);
            sb.append("  Sequence Number: ").append(this.getSequenceNumberAsLong()).append(ls);
            sb.append("  Acknowledgment Number: ").append(this.getAcknowledgmentNumberAsLong()).append(ls);
            sb.append("  Data Offset: ").append(this.dataOffset).append(" (").append(this.dataOffset * 4).append(" [bytes])").append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            sb.append("  URG: ").append(this.urg).append(ls);
            sb.append("  ACK: ").append(this.ack).append(ls);
            sb.append("  PSH: ").append(this.psh).append(ls);
            sb.append("  RST: ").append(this.rst).append(ls);
            sb.append("  SYN: ").append(this.syn).append(ls);
            sb.append("  FIN: ").append(this.fin).append(ls);
            sb.append("  Window: ").append(this.getWindowAsInt()).append(ls);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls);
            sb.append("  Urgent Pointer: ").append(this.getUrgentPointerAsInt()).append(ls);
            for (TcpOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            if (this.padding.length != 0) {
                sb.append("  Padding: 0x").append(ByteArrays.toHexString(this.padding, " ")).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            TcpHeader other = (TcpHeader)obj;
            return this.checksum == other.checksum && this.sequenceNumber == other.sequenceNumber && this.acknowledgmentNumber == other.acknowledgmentNumber && this.dataOffset == other.dataOffset && this.srcPort.equals(other.srcPort) && this.dstPort.equals(other.dstPort) && this.urg == other.urg && this.ack == other.ack && this.psh == other.psh && this.rst == other.rst && this.syn == other.syn && this.fin == other.fin && this.window == other.window && this.urgentPointer == other.urgentPointer && this.reserved == other.reserved && this.options.equals(other.options) && Arrays.equals(this.padding, other.padding);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.srcPort.hashCode();
            result = 31 * result + this.dstPort.hashCode();
            result = 31 * result + this.sequenceNumber;
            result = 31 * result + this.acknowledgmentNumber;
            result = 31 * result + this.dataOffset;
            result = 31 * result + this.reserved;
            result = 31 * result + (this.urg ? 1231 : 1237);
            result = 31 * result + (this.ack ? 1231 : 1237);
            result = 31 * result + (this.psh ? 1231 : 1237);
            result = 31 * result + (this.rst ? 1231 : 1237);
            result = 31 * result + (this.syn ? 1231 : 1237);
            result = 31 * result + (this.fin ? 1231 : 1237);
            result = 31 * result + this.window;
            result = 31 * result + this.checksum;
            result = 31 * result + this.urgentPointer;
            result = 31 * result + this.options.hashCode();
            result = 31 * result + Arrays.hashCode(this.padding);
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<TcpPacket>,
    ChecksumBuilder<TcpPacket> {
        private TcpPort srcPort;
        private TcpPort dstPort;
        private int sequenceNumber;
        private int acknowledgmentNumber;
        private byte dataOffset;
        private byte reserved;
        private boolean urg;
        private boolean ack;
        private boolean psh;
        private boolean rst;
        private boolean syn;
        private boolean fin;
        private short window;
        private short checksum;
        private short urgentPointer;
        private List<TcpOption> options;
        private byte[] padding;
        private Packet.Builder payloadBuilder;
        private InetAddress srcAddr;
        private InetAddress dstAddr;
        private boolean correctLengthAtBuild;
        private boolean correctChecksumAtBuild;
        private boolean paddingAtBuild;

        public Builder() {
        }

        public Builder(TcpPacket packet) {
            this.srcPort = packet.header.srcPort;
            this.dstPort = packet.header.dstPort;
            this.sequenceNumber = packet.header.sequenceNumber;
            this.acknowledgmentNumber = packet.header.acknowledgmentNumber;
            this.dataOffset = packet.header.dataOffset;
            this.reserved = packet.header.reserved;
            this.urg = packet.header.urg;
            this.ack = packet.header.ack;
            this.psh = packet.header.psh;
            this.rst = packet.header.rst;
            this.syn = packet.header.syn;
            this.fin = packet.header.fin;
            this.window = packet.header.window;
            this.checksum = packet.header.checksum;
            this.urgentPointer = packet.header.urgentPointer;
            this.options = packet.header.options;
            this.padding = packet.header.padding;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder srcPort(TcpPort srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public Builder dstPort(TcpPort dstPort) {
            this.dstPort = dstPort;
            return this;
        }

        public Builder sequenceNumber(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder acknowledgmentNumber(int acknowledgmentNumber) {
            this.acknowledgmentNumber = acknowledgmentNumber;
            return this;
        }

        public Builder dataOffset(byte dataOffset) {
            this.dataOffset = dataOffset;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder urg(boolean urg) {
            this.urg = urg;
            return this;
        }

        public Builder ack(boolean ack) {
            this.ack = ack;
            return this;
        }

        public Builder psh(boolean psh) {
            this.psh = psh;
            return this;
        }

        public Builder rst(boolean rst) {
            this.rst = rst;
            return this;
        }

        public Builder syn(boolean syn) {
            this.syn = syn;
            return this;
        }

        public Builder fin(boolean fin) {
            this.fin = fin;
            return this;
        }

        public Builder window(short window) {
            this.window = window;
            return this;
        }

        public Builder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder urgentPointer(short urgentPointer) {
            this.urgentPointer = urgentPointer;
            return this;
        }

        public Builder options(List<TcpOption> options) {
            this.options = options;
            return this;
        }

        public Builder padding(byte[] padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder srcAddr(InetAddress srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder dstAddr(InetAddress dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        public Builder paddingAtBuild(boolean paddingAtBuild) {
            this.paddingAtBuild = paddingAtBuild;
            return this;
        }

        @Override
        public TcpPacket build() {
            return new TcpPacket(this);
        }
    }
}

