/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class IpV4TosPrecedence
extends NamedNumber<Byte, IpV4TosPrecedence> {
    private static final long serialVersionUID = 3155818580398801532L;
    public static final IpV4TosPrecedence ROUTINE = new IpV4TosPrecedence((byte)0, "Routine");
    public static final IpV4TosPrecedence PRIORITY = new IpV4TosPrecedence((byte)1, "Priority");
    public static final IpV4TosPrecedence IMMEDIATE = new IpV4TosPrecedence((byte)2, "Immediate");
    public static final IpV4TosPrecedence FLASH = new IpV4TosPrecedence((byte)3, "Flash");
    public static final IpV4TosPrecedence FLASH_OVERRIDE = new IpV4TosPrecedence((byte)4, "Flash Override");
    public static final IpV4TosPrecedence CRITIC_ECP = new IpV4TosPrecedence((byte)5, "CRITIC/ECP");
    public static final IpV4TosPrecedence INTERNETWORK_CONTROL = new IpV4TosPrecedence((byte)6, "Internetwork Control/ECP");
    public static final IpV4TosPrecedence NETWORK_CONTROL = new IpV4TosPrecedence((byte)7, "Network Control");
    private static final Map<Byte, IpV4TosPrecedence> registry = new HashMap<Byte, IpV4TosPrecedence>();

    public IpV4TosPrecedence(Byte value, String name) {
        super(value, name);
        if ((value & 0xF8) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. " + "Precedence field of IPv4 TOS must be between 0 and 7");
        }
    }

    public static IpV4TosPrecedence getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4TosPrecedence(value, "unknown");
    }

    public static IpV4TosPrecedence register(IpV4TosPrecedence precedence) {
        return registry.put((Byte)precedence.value(), precedence);
    }

    @Override
    public int compareTo(IpV4TosPrecedence o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    static {
        registry.put((Byte)ROUTINE.value(), ROUTINE);
        registry.put((Byte)PRIORITY.value(), PRIORITY);
        registry.put((Byte)IMMEDIATE.value(), IMMEDIATE);
        registry.put((Byte)FLASH.value(), FLASH);
        registry.put((Byte)FLASH_OVERRIDE.value(), FLASH_OVERRIDE);
        registry.put((Byte)CRITIC_ECP.value(), CRITIC_ECP);
        registry.put((Byte)INTERNETWORK_CONTROL.value(), INTERNETWORK_CONTROL);
        registry.put((Byte)NETWORK_CONTROL.value(), NETWORK_CONTROL);
    }
}

