/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Callback;
import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NativeMappings {
    private static final Logger LOG = LoggerFactory.getLogger(NativeMappings.class);
    static final String PCAP_LIB_NAME = System.getProperty(NativeMappings.class.getPackage().getName() + ".pcapLibName", Platform.isWindows() ? "wpcap" : "pcap");
    static final Function PCAP_DUMP = Function.getFunction((String)PCAP_LIB_NAME, (String)"pcap_dump");
    static final Map<String, Object> NATIVE_LOAD_LIBRARY_OPTIONS = new HashMap<String, Object>();
    static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    static final int SBIOCSTIME = 16897;
    static final Pointer ERRNO_P = Platform.isSolaris() ? NativeLibrary.getInstance((String)PCAP_LIB_NAME).getGlobalVariableAddress("errno") : null;

    NativeMappings() {
    }

    static int getFdFromPcapT(Pointer p) {
        if (Platform.isWindows()) {
            return -1;
        }
        return p.getInt(0L);
    }

    static native int pcap_findalldevs(PointerByReference var0, PcapErrbuf var1);

    static native void pcap_freealldevs(Pointer var0);

    static native Pointer pcap_lookupdev(PcapErrbuf var0);

    static native int pcap_lookupnet(String var0, IntByReference var1, IntByReference var2, PcapErrbuf var3);

    static native Pointer pcap_open_live(String var0, int var1, int var2, int var3, PcapErrbuf var4);

    static native Pointer pcap_open_dead(int var0, int var1);

    static native Pointer pcap_open_offline(String var0, PcapErrbuf var1);

    static native int pcap_setnonblock(Pointer var0, int var1, PcapErrbuf var2);

    static native int pcap_getnonblock(Pointer var0, PcapErrbuf var1);

    static native Pointer pcap_dump_open(Pointer var0, String var1);

    static native void pcap_dump(Pointer var0, pcap_pkthdr var1, byte[] var2);

    static native int pcap_dump_flush(Pointer var0);

    static native NativeLong pcap_dump_ftell(Pointer var0);

    static native void pcap_dump_close(Pointer var0);

    static native int pcap_dispatch(Pointer var0, int var1, pcap_handler var2, Pointer var3);

    static native Pointer pcap_next(Pointer var0, pcap_pkthdr var1);

    static native int pcap_next_ex(Pointer var0, PointerByReference var1, PointerByReference var2);

    static native int pcap_loop(Pointer var0, int var1, pcap_handler var2, Pointer var3);

    static native int pcap_loop(Pointer var0, int var1, Function var2, Pointer var3);

    static native void pcap_breakloop(Pointer var0);

    static native int pcap_compile(Pointer var0, bpf_program var1, String var2, int var3, int var4);

    static native int pcap_compile_nopcap(int var0, int var1, bpf_program var2, String var3, int var4, int var5);

    static native int bpf_filter(bpf_insn.ByReference var0, byte[] var1, int var2, int var3);

    static native int pcap_setfilter(Pointer var0, bpf_program var1);

    static native void pcap_freecode(bpf_program var0);

    static native int pcap_sendpacket(Pointer var0, byte[] var1, int var2);

    static native void pcap_close(Pointer var0);

    static native int pcap_datalink(Pointer var0);

    static native int pcap_list_datalinks(Pointer var0, PointerByReference var1);

    static native void pcap_free_datalinks(Pointer var0);

    static native int pcap_set_datalink(Pointer var0, int var1);

    static native int pcap_datalink_name_to_val(String var0);

    static native String pcap_datalink_val_to_name(int var0);

    static native String pcap_datalink_val_to_description(int var0);

    static native int pcap_snapshot(Pointer var0);

    static native int pcap_is_swapped(Pointer var0);

    static native int pcap_major_version(Pointer var0);

    static native int pcap_minor_version(Pointer var0);

    static native int pcap_stats(Pointer var0, pcap_stat var1);

    static native Pointer pcap_geterr(Pointer var0);

    static native Pointer pcap_strerror(int var0);

    static native String pcap_lib_version();

    static native Pointer pcap_create(String var0, PcapErrbuf var1);

    static native int pcap_set_snaplen(Pointer var0, int var1);

    static native int pcap_set_promisc(Pointer var0, int var1);

    static native int pcap_set_timeout(Pointer var0, int var1);

    static native int pcap_set_buffer_size(Pointer var0, int var1);

    static native int pcap_setdirection(Pointer var0, int var1);

    static native int pcap_activate(Pointer var0);

    static {
        Native.register(NativeMappings.class, (NativeLibrary)NativeLibrary.getInstance((String)PCAP_LIB_NAME));
        final HashMap<String, String> funcMap = new HashMap<String, String>();
        funcMap.put("pcap_set_rfmon", "pcap_set_rfmon");
        funcMap.put("strioctl", "strioctl");
        funcMap.put("dos_pcap_stats_ex", "pcap_stats_ex");
        funcMap.put("win_pcap_stats_ex", "pcap_stats_ex");
        funcMap.put("pcap_open_offline_with_tstamp_precision", "pcap_open_offline_with_tstamp_precision");
        funcMap.put("pcap_open_dead_with_tstamp_precision", "pcap_open_dead_with_tstamp_precision");
        funcMap.put("pcap_set_tstamp_precision", "pcap_set_tstamp_precision");
        NATIVE_LOAD_LIBRARY_OPTIONS.put("function-mapper", new FunctionMapper(){

            public String getFunctionName(NativeLibrary library, Method method) {
                return (String)funcMap.get(method.getName());
            }
        });
        LOG.info("Pcap4J successfully loaded a native pcap library: {}", (Object)NativeMappings.pcap_lib_version());
    }

    public static class PcapErrbuf
    extends Structure {
        public byte[] buf = new byte[PcapErrbuf.PCAP_ERRBUF_SIZE()];

        private static int PCAP_ERRBUF_SIZE() {
            return 256;
        }

        public int length() {
            return this.toString().length();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("buf");
            return list;
        }

        public String toString() {
            return Native.toString((byte[])this.buf);
        }
    }

    public static class pcap_stat_ex
    extends Structure {
        public NativeLong rx_packets;
        public NativeLong tx_packets;
        public NativeLong rx_bytes;
        public NativeLong tx_bytes;
        public NativeLong rx_errors;
        public NativeLong tx_errors;
        public NativeLong rx_dropped;
        public NativeLong tx_dropped;
        public NativeLong multicast;
        public NativeLong collisions;
        public NativeLong rx_length_errors;
        public NativeLong rx_over_errors;
        public NativeLong rx_crc_errors;
        public NativeLong rx_frame_errors;
        public NativeLong rx_fifo_errors;
        public NativeLong rx_missed_errors;
        public NativeLong tx_aborted_errors;
        public NativeLong tx_carrier_errors;
        public NativeLong tx_fifo_errors;
        public NativeLong tx_heartbeat_errors;
        public NativeLong tx_window_errors;

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("rx_packets");
            list.add("tx_packets");
            list.add("rx_bytes");
            list.add("tx_bytes");
            list.add("rx_errors");
            list.add("tx_errors");
            list.add("rx_dropped");
            list.add("tx_dropped");
            list.add("multicast");
            list.add("collisions");
            list.add("rx_length_errors");
            list.add("rx_over_errors");
            list.add("rx_crc_errors");
            list.add("rx_frame_errors");
            list.add("rx_fifo_errors");
            list.add("rx_missed_errors");
            list.add("tx_aborted_errors");
            list.add("tx_carrier_errors");
            list.add("tx_fifo_errors");
            list.add("tx_heartbeat_errors");
            list.add("tx_window_errors");
            return list;
        }

        public static class ByReference
        extends pcap_stat_ex
        implements Structure.ByReference {
        }
    }

    public static class win_pcap_stat
    extends pcap_stat {
        public static final int BS_CAPT_OFFSET;
        public int bs_capt;

        public win_pcap_stat() {
        }

        public win_pcap_stat(Pointer p) {
            super(p);
            this.read();
        }

        @Override
        protected List<String> getFieldOrder() {
            List<String> list = super.getFieldOrder();
            list.add("bs_capt");
            return list;
        }

        static int getBsCapt(Pointer p) {
            return p.getInt((long)BS_CAPT_OFFSET);
        }

        static {
            win_pcap_stat ph = new win_pcap_stat();
            BS_CAPT_OFFSET = ph.fieldOffset("bs_capt");
        }

        public static class ByReference
        extends win_pcap_stat
        implements Structure.ByReference {
        }
    }

    public static class pcap_stat
    extends Structure {
        public static final int PS_RECV_OFFSET;
        public static final int PS_DROP_OFFSET;
        public static final int PS_IFDROP_OFFSET;
        public int ps_recv;
        public int ps_drop;
        public int ps_ifdrop;

        public pcap_stat() {
        }

        public pcap_stat(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("ps_recv");
            list.add("ps_drop");
            list.add("ps_ifdrop");
            return list;
        }

        static int getPsRecv(Pointer p) {
            return p.getInt((long)PS_RECV_OFFSET);
        }

        static int getPsDrop(Pointer p) {
            return p.getInt((long)PS_DROP_OFFSET);
        }

        static int getPsIfdrop(Pointer p) {
            return p.getInt((long)PS_IFDROP_OFFSET);
        }

        static {
            pcap_stat ph = new pcap_stat();
            PS_RECV_OFFSET = ph.fieldOffset("ps_recv");
            PS_DROP_OFFSET = ph.fieldOffset("ps_drop");
            PS_IFDROP_OFFSET = ph.fieldOffset("ps_ifdrop");
        }

        public static class ByReference
        extends pcap_stat
        implements Structure.ByReference {
        }
    }

    public static class bpf_insn
    extends Structure {
        public short code;
        public byte jt;
        public byte jf;
        public int k;

        public bpf_insn() {
            this.setAutoSynch(false);
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("code");
            list.add("jt");
            list.add("jf");
            list.add("k");
            return list;
        }

        public static class ByReference
        extends bpf_insn
        implements Structure.ByReference {
        }
    }

    public static class bpf_program
    extends Structure {
        public int bf_len;
        public bpf_insn.ByReference bf_insns;

        public bpf_program() {
            this.setAutoSynch(false);
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("bf_len");
            list.add("bf_insns");
            return list;
        }
    }

    public static class timeval
    extends Structure {
        public static final int TV_SEC_OFFSET;
        public static final int TV_USEC_OFFSET;
        public NativeLong tv_sec;
        public NativeLong tv_usec;

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("tv_sec");
            list.add("tv_usec");
            return list;
        }

        static {
            timeval tv = new timeval();
            TV_SEC_OFFSET = tv.fieldOffset("tv_sec");
            TV_USEC_OFFSET = tv.fieldOffset("tv_usec");
        }
    }

    public static class pcap_pkthdr
    extends Structure {
        public static final int TS_OFFSET;
        public static final int CAPLEN_OFFSET;
        public static final int LEN_OFFSET;
        public timeval ts;
        public int caplen;
        public int len;

        public pcap_pkthdr() {
        }

        public pcap_pkthdr(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("ts");
            list.add("caplen");
            list.add("len");
            return list;
        }

        static NativeLong getTvSec(Pointer p) {
            return p.getNativeLong((long)(TS_OFFSET + timeval.TV_SEC_OFFSET));
        }

        static NativeLong getTvUsec(Pointer p) {
            return p.getNativeLong((long)(TS_OFFSET + timeval.TV_USEC_OFFSET));
        }

        static int getCaplen(Pointer p) {
            return p.getInt((long)CAPLEN_OFFSET);
        }

        static int getLen(Pointer p) {
            return p.getInt((long)LEN_OFFSET);
        }

        static {
            pcap_pkthdr ph = new pcap_pkthdr();
            TS_OFFSET = ph.fieldOffset("ts");
            CAPLEN_OFFSET = ph.fieldOffset("caplen");
            LEN_OFFSET = ph.fieldOffset("len");
        }

        public static class ByReference
        extends pcap_pkthdr
        implements Structure.ByReference {
        }
    }

    public static class sockaddr_dl
    extends Structure {
        public byte sdl_len;
        public byte sdl_family;
        public short sdl_index;
        public byte sdl_type;
        public byte sdl_nlen;
        public byte sdl_alen;
        public byte sdl_slen;
        public byte[] sdl_data = new byte[46];

        public sockaddr_dl() {
        }

        public sockaddr_dl(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("sdl_len");
            list.add("sdl_family");
            list.add("sdl_index");
            list.add("sdl_type");
            list.add("sdl_nlen");
            list.add("sdl_alen");
            list.add("sdl_slen");
            list.add("sdl_data");
            return list;
        }

        byte[] getAddress() {
            return this.getPointer().getByteArray((long)(8 + (0xFF & this.sdl_nlen)), 0xFF & this.sdl_alen);
        }
    }

    public static class sockaddr_ll
    extends Structure {
        public short sll_family;
        public short sll_protocol;
        public int sll_ifindex;
        public short sll_hatype;
        public byte sll_pkttype;
        public byte sll_halen;
        public byte[] sll_addr = new byte[8];

        public sockaddr_ll() {
        }

        public sockaddr_ll(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("sll_family");
            list.add("sll_protocol");
            list.add("sll_ifindex");
            list.add("sll_hatype");
            list.add("sll_pkttype");
            list.add("sll_halen");
            list.add("sll_addr");
            return list;
        }

        short getSaFamily() {
            if (sockaddr.isWindowsType()) {
                return this.sll_family;
            }
            if (NATIVE_BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
                return (short)(0xFF & this.sll_family);
            }
            return (short)(0xFF & this.sll_family >> 8);
        }
    }

    public static class in6_addr
    extends Structure {
        public byte[] s6_addr = new byte[16];

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("s6_addr");
            return list;
        }
    }

    public static class sockaddr_in6
    extends Structure {
        public short sin6_family;
        public short sin6_port;
        public int sin6_flowinfo;
        public in6_addr sin6_addr;
        public int sin6_scope_id;

        public sockaddr_in6() {
        }

        public sockaddr_in6(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("sin6_family");
            list.add("sin6_port");
            list.add("sin6_flowinfo");
            list.add("sin6_addr");
            list.add("sin6_scope_id");
            return list;
        }

        short getSaFamily() {
            if (sockaddr.isWindowsType()) {
                return this.sin6_family;
            }
            if (NATIVE_BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
                return (short)(0xFF & this.sin6_family);
            }
            return (short)(0xFF & this.sin6_family >> 8);
        }
    }

    public static class in_addr
    extends Structure {
        public int s_addr;

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("s_addr");
            return list;
        }
    }

    public static class sockaddr_in
    extends Structure {
        public short sin_family;
        public short sin_port;
        public in_addr sin_addr;
        public byte[] sin_zero = new byte[8];

        public sockaddr_in() {
        }

        public sockaddr_in(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("sin_family");
            list.add("sin_port");
            list.add("sin_addr");
            list.add("sin_zero");
            return list;
        }

        short getSaFamily() {
            if (sockaddr.isWindowsType()) {
                return this.sin_family;
            }
            if (NATIVE_BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
                return (short)(0xFF & this.sin_family);
            }
            return (short)(0xFF & this.sin_family >> 8);
        }
    }

    public static class sockaddr
    extends Structure {
        public short sa_family;
        public byte[] sa_data = new byte[14];

        public sockaddr() {
        }

        public sockaddr(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("sa_family");
            list.add("sa_data");
            return list;
        }

        short getSaFamily() {
            if (sockaddr.isWindowsType()) {
                return this.sa_family;
            }
            if (NATIVE_BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
                return (short)(0xFF & this.sa_family);
            }
            return (short)(0xFF & this.sa_family >> 8);
        }

        static boolean isWindowsType() {
            return !Platform.isMac() && !Platform.isFreeBSD() && !Platform.isOpenBSD() && !Platform.iskFreeBSD();
        }

        public static class ByReference
        extends sockaddr
        implements Structure.ByReference {
        }
    }

    public static class pcap_addr
    extends Structure {
        public ByReference next;
        public sockaddr.ByReference addr;
        public sockaddr.ByReference netmask;
        public sockaddr.ByReference broadaddr;
        public sockaddr.ByReference dstaddr;

        public pcap_addr() {
        }

        public pcap_addr(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("next");
            list.add("addr");
            list.add("netmask");
            list.add("broadaddr");
            list.add("dstaddr");
            return list;
        }

        public static class ByReference
        extends pcap_addr
        implements Structure.ByReference {
        }
    }

    public static class pcap_if
    extends Structure {
        public ByReference next;
        public String name;
        public String description;
        public pcap_addr.ByReference addresses;
        public int flags;

        public pcap_if() {
        }

        public pcap_if(Pointer p) {
            super(p);
            this.read();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> list = new ArrayList<String>();
            list.add("next");
            list.add("name");
            list.add("description");
            list.add("addresses");
            list.add("flags");
            return list;
        }

        public static class ByReference
        extends pcap_if
        implements Structure.ByReference {
        }
    }

    static interface pcap_handler
    extends Callback {
        public void got_packet(Pointer var1, Pointer var2, Pointer var3);
    }

    static interface PcapLibrary
    extends Library {
        public static final PcapLibrary INSTANCE = (PcapLibrary)Native.loadLibrary((String)PCAP_LIB_NAME, PcapLibrary.class, NATIVE_LOAD_LIBRARY_OPTIONS);

        public int pcap_set_rfmon(Pointer var1, int var2);

        public int strioctl(int var1, int var2, int var3, Pointer var4);

        public int dos_pcap_stats_ex(Pointer var1, pcap_stat_ex var2);

        public Pointer win_pcap_stats_ex(Pointer var1, IntByReference var2);

        public Pointer pcap_open_offline_with_tstamp_precision(String var1, int var2, PcapErrbuf var3);

        public Pointer pcap_open_dead_with_tstamp_precision(int var1, int var2, int var3);

        public int pcap_set_tstamp_precision(Pointer var1, int var2);
    }
}

