/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;

public final class ByteArrays {
    public static final int BYTE_SIZE_IN_BYTES = 1;
    public static final int SHORT_SIZE_IN_BYTES = 2;
    public static final int INT_SIZE_IN_BYTES = 4;
    public static final int LONG_SIZE_IN_BYTES = 8;
    public static final int INET4_ADDRESS_SIZE_IN_BYTES = 4;
    public static final int INET6_ADDRESS_SIZE_IN_BYTES = 16;
    public static final int BYTE_SIZE_IN_BITS = 8;
    private static final Pattern NO_SEPARATOR_HEX_STRING_PATTERN = Pattern.compile("\\A([0-9a-fA-F][0-9a-fA-F])+\\z");
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final int[] CRC32C_TABLE = new int[]{0, -227835133, -516198153, 324072436, -946170081, 904991772, 648144872, -724933397, -1965467441, 2024987596, 1809983544, -1719030981, 1296289744, -1087877933, -1401372889, 1578318884, 274646895, -499825556, -244992104, 51262619, -675000208, 632279923, 922689671, -996891772, -1702387808, 1760304291, 2075979607, -1982370732, 1562183871, -1351185476, -1138329528, 1313733451, 549293790, -757723683, -1048117719, 871202090, -416867903, 357341890, 102525238, -193467851, -1436232175, 1477399826, 1264559846, -1187764763, 1845379342, -1617575411, -1933233671, 2125378298, 820201905, -1031222606, -774358714, 598981189, -143008082, 85089709, 373468761, -467063462, -1170599554, 1213305469, 1526817161, -1452612982, 2107672161, -1882520222, -1667500394, 1861252501, 1098587580, -1290756417, -1606390453, 1378610760, -2032039261, 1955203488, 1742404180, -1783531177, -878557837, 969524848, 714683780, -655182201, 205050476, -28094097, -318528869, 526918040, 1361435347, -1555146288, -1340167644, 1114974503, -1765847604, 1691668175, 2005155131, -2047885768, -604208612, 697762079, 986182379, -928222744, 476452099, -301099520, -44210700, 255256311, 1640403810, -1817374623, -2130844779, 1922457750, -1503918979, 1412925310, 1197962378, -1257441399, -350237779, 427051182, 170179418, -129025959, 746937522, -554770511, -843174843, 1070968646, 1905808397, -2081171698, -1868356358, 1657317369, -1241332974, 1147748369, 1463399397, -1521340186, -79622974, 153784257, 444234805, -401473738, 1021025245, -827320098, -572462294, 797665321, -2097792136, 1889384571, 1674398607, -1851340660, 1164749927, -1224265884, -1537745776, 1446797203, 137323447, -96149324, -384560320, 461344835, -810158936, 1037989803, 781091935, -588970148, -1834419177, 1623424788, 1939049696, -2114449437, 1429367560, -1487280117, -1274471425, 1180866812, 410100952, -367384613, -112536529, 186734380, -538233913, 763408580, 1053836080, -860110797, -1572096602, 1344288421, 1131464017, -1323612590, 1708204729, -1749376582, -2065018290, 1988219213, 680717673, -621187478, -911630946, 1002577565, -284657034, 493091189, 238226049, -61306494, -1307217207, 1082061258, 1395524158, -1589280451, 1972364758, -2015074603, -1800104671, 1725896226, 952904198, -894981883, -638100751, 731699698, -11092711, 222117402, 510512622, -335130899, -1014159676, 837199303, 582374963, -790768336, 68661723, -159632680, -450051796, 390545967, 1230274059, -1153434360, -1469116676, 1510247935, -1899042540, 2091215383, 1878366691, -1650582816, -741088853, 565732008, 854102364, -1065151905, 340358836, -433916489, -177076669, 119113024, 1493875044, -1419691417, -1204696685, 1247431312, -1634718085, 1828433272, 2141937292, -1916740209, -483350502, 291187481, 34330861, -262120466, 615137029, -691946490, -980332558, 939183345, 1776939221, -1685949482, -1999470558, 2058945313, -1368168502, 1545135305, 1330124605, -1121741762, -210866315, 17165430, 307568514, -532767615, 888469610, -962626711, -707819363, 665062302, 2042050490, -1948470087, -1735637171, 1793573966, -1104306011, 1279665062, 1595330642, -1384295599};

    private ByteArrays() {
        throw new AssertionError();
    }

    public static byte[] reverse(byte[] array) {
        byte[] rarray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            rarray[i] = array[array.length - i - 1];
        }
        return rarray;
    }

    public static byte getByte(byte[] array, int offset) {
        ByteArrays.validateBounds(array, offset, 1);
        return array[offset];
    }

    public static byte[] toByteArray(byte value) {
        return new byte[]{value};
    }

    public static String toHexString(byte value, String separator) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value), separator);
    }

    public static short getShort(byte[] array, int offset) {
        return ByteArrays.getShort(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static short getShort(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 2);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return (short)(array[offset + 1] << 8 | 0xFF & array[offset]);
        }
        return (short)(array[offset] << 8 | 0xFF & array[offset + 1]);
    }

    public static byte[] toByteArray(short value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(short value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8)};
        }
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static String toHexString(short value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(short value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static int getInt(byte[] array, int offset) {
        return ByteArrays.getInt(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static int getInt(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 4);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return array[offset + 3] << 24 | (0xFF & array[offset + 2]) << 16 | (0xFF & array[offset + 1]) << 8 | 0xFF & array[offset];
        }
        return array[offset] << 24 | (0xFF & array[offset + 1]) << 16 | (0xFF & array[offset + 2]) << 8 | 0xFF & array[offset + 3];
    }

    public static int getInt(byte[] array, int offset, int length) {
        return ByteArrays.getInt(array, offset, length, ByteOrder.BIG_ENDIAN);
    }

    public static int getInt(byte[] array, int offset, int length, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, length);
        if (length > 4) {
            StringBuilder sb = new StringBuilder(30).append("length must be equal or less than ").append(4).append(", but is: ").append(length);
            throw new IllegalArgumentException(sb.toString());
        }
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        int value = 0;
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            for (int i = offset + length - 1; i >= offset; --i) {
                value <<= 8;
                value |= 0xFF & array[i];
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value <<= 8;
                value |= 0xFF & array[i];
            }
        }
        return value;
    }

    public static byte[] toByteArray(int value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(int value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        }
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] toByteArray(int value, int length) {
        return ByteArrays.toByteArray(value, length, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(int value, int length, ByteOrder bo) {
        if (length > 4) {
            StringBuilder sb = new StringBuilder(30).append("length must be equal or less than ").append(4).append(", but is: ").append(length);
            throw new IllegalArgumentException(sb.toString());
        }
        byte[] arr = new byte[length];
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            for (int i = 0; i < length; ++i) {
                arr[length - i - 1] = (byte)(value >> 8 * i);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                arr[i] = (byte)(value >> 8 * i);
            }
        }
        return arr;
    }

    public static String toHexString(int value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(int value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static long getLong(byte[] array, int offset) {
        return ByteArrays.getLong(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static long getLong(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 8);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return (long)array[offset + 7] << 56 | (0xFFL & (long)array[offset + 6]) << 48 | (0xFFL & (long)array[offset + 5]) << 40 | (0xFFL & (long)array[offset + 4]) << 32 | (0xFFL & (long)array[offset + 3]) << 24 | (0xFFL & (long)array[offset + 2]) << 16 | (0xFFL & (long)array[offset + 1]) << 8 | 0xFFL & (long)array[offset];
        }
        return (long)array[offset] << 56 | (0xFFL & (long)array[offset + 1]) << 48 | (0xFFL & (long)array[offset + 2]) << 40 | (0xFFL & (long)array[offset + 3]) << 32 | (0xFFL & (long)array[offset + 4]) << 24 | (0xFFL & (long)array[offset + 5]) << 16 | (0xFFL & (long)array[offset + 6]) << 8 | 0xFFL & (long)array[offset + 7];
    }

    public static byte[] toByteArray(long value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(long value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        }
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static String toHexString(long value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(long value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static MacAddress getMacAddress(byte[] array, int offset) {
        return ByteArrays.getMacAddress(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static MacAddress getMacAddress(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 6);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return MacAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 6)));
        }
        return MacAddress.getByAddress(ByteArrays.getSubArray(array, offset, 6));
    }

    public static byte[] toByteArray(MacAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(MacAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static LinkLayerAddress getLinkLayerAddress(byte[] array, int offset, int length) {
        return ByteArrays.getLinkLayerAddress(array, offset, length, ByteOrder.BIG_ENDIAN);
    }

    public static LinkLayerAddress getLinkLayerAddress(byte[] array, int offset, int length, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, length);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return LinkLayerAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, length)));
        }
        return LinkLayerAddress.getByAddress(ByteArrays.getSubArray(array, offset, length));
    }

    public static byte[] toByteArray(LinkLayerAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(LinkLayerAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static Inet4Address getInet4Address(byte[] array, int offset) {
        return ByteArrays.getInet4Address(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static Inet4Address getInet4Address(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 4);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        try {
            if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
                return (Inet4Address)InetAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 4)));
            }
            return (Inet4Address)InetAddress.getByAddress(ByteArrays.getSubArray(array, offset, 4));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Inet6Address getInet6Address(byte[] array, int offset) {
        return ByteArrays.getInet6Address(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static Inet6Address getInet6Address(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 16);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        try {
            if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
                return (Inet6Address)InetAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 16)));
            }
            return (Inet6Address)InetAddress.getByAddress(ByteArrays.getSubArray(array, offset, 16));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] toByteArray(InetAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(InetAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static byte[] getSubArray(byte[] array, int offset, int length) {
        ByteArrays.validateBounds(array, offset, length);
        byte[] subArray = new byte[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static byte[] getSubArray(byte[] array, int offset) {
        return ByteArrays.getSubArray(array, offset, array.length - offset);
    }

    public static String toHexString(byte[] array, String separator) {
        return ByteArrays.toHexString(array, separator, 0, array.length);
    }

    public static String toHexString(byte[] array, String separator, int offset, int length) {
        char[] hexChars;
        ByteArrays.validateBounds(array, offset, length);
        if (separator.length() != 0) {
            int v;
            int i;
            char[] sepChars = separator.toCharArray();
            hexChars = new char[length * 2 + sepChars.length * (length - 1)];
            int cur = 0;
            for (i = 0; i < length - 1; ++i) {
                v = array[offset + i] & 0xFF;
                hexChars[cur] = HEX_CHARS[v >>> 4];
                hexChars[++cur] = HEX_CHARS[v & 0xF];
                ++cur;
                for (int j = 0; j < sepChars.length; ++j) {
                    hexChars[cur] = sepChars[j];
                    ++cur;
                }
            }
            v = array[offset + i] & 0xFF;
            hexChars[cur] = HEX_CHARS[v >>> 4];
            hexChars[cur + 1] = HEX_CHARS[v & 0xF];
        } else {
            hexChars = new char[length * 2];
            int cur = 0;
            for (int i = 0; i < length; ++i) {
                int v = array[offset + i] & 0xFF;
                hexChars[cur] = HEX_CHARS[v >>> 4];
                hexChars[++cur] = HEX_CHARS[v & 0xF];
                ++cur;
            }
        }
        return new String(hexChars);
    }

    public static short calcChecksum(byte[] data) {
        long sum = 0L;
        for (int i = 1; i < data.length; i += 2) {
            sum += 0xFFFFL & (long)ByteArrays.getShort(data, i - 1);
        }
        if (data.length % 2 != 0) {
            sum += 0xFFFFL & (long)(data[data.length - 1] << 8);
        }
        while (sum >> 16 != 0L) {
            sum = (0xFFFFL & sum) + (sum >>> 16);
        }
        return (short)(sum ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int calcCrc32Checksum(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return (int)crc32.getValue();
    }

    public static int calcCrc32cChecksum(byte[] data) {
        int c = -1;
        for (int i = 0; i < data.length; ++i) {
            c = CRC32C_TABLE[(c ^ data[i]) & 0xFF] ^ c >>> 8;
        }
        return ~c;
    }

    public static int calcAdler32Checksum(byte[] data) {
        Adler32 adler32 = new Adler32();
        adler32.update(data);
        return (int)adler32.getValue();
    }

    public static byte[] parseByteArray(String hexString, String separator) {
        String noSeparatorHexString;
        if (hexString == null || separator == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("hexString: ").append(hexString).append(" separator: ").append(separator);
            throw new NullPointerException(sb.toString());
        }
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        if (separator.length() == 0) {
            if (!NO_SEPARATOR_HEX_STRING_PATTERN.matcher(hexString).matches()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("invalid hex string(").append(hexString).append("), not match pattern(").append(NO_SEPARATOR_HEX_STRING_PATTERN.pattern()).append(")");
                throw new IllegalArgumentException(sb.toString());
            }
            noSeparatorHexString = hexString;
        } else {
            StringBuilder patternSb = new StringBuilder(60);
            patternSb.append("\\A[0-9a-fA-F][0-9a-fA-F](").append(Pattern.quote(separator)).append("[0-9a-fA-F][0-9a-fA-F])*\\z");
            String patternString = patternSb.toString();
            Pattern pattern = Pattern.compile(patternString);
            if (!pattern.matcher(hexString).matches()) {
                StringBuilder sb = new StringBuilder(150);
                sb.append("invalid hex string(").append(hexString).append("), not match pattern(").append(patternString).append(")");
                throw new IllegalArgumentException(sb.toString());
            }
            noSeparatorHexString = hexString.replaceAll(Pattern.quote(separator), "");
        }
        int arrayLength = noSeparatorHexString.length() / 2;
        byte[] array = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = (byte)Integer.parseInt(noSeparatorHexString.substring(i * 2, i * 2 + 2), 16);
        }
        return array;
    }

    public static byte[] clone(byte[] array) {
        byte[] clone = new byte[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }

    public static void validateBounds(byte[] arr, int offset, int len) {
        if (arr == null) {
            throw new NullPointerException("arr must not be null.");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("arr is empty.");
        }
        if (len == 0) {
            throw new IllegalArgumentException("length is zero.");
        }
        if (offset < 0 || len < 0 || offset + len > arr.length) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("arr.length: ").append(arr.length).append(", offset: ").append(offset).append(", len: ").append(len);
            throw new ArrayIndexOutOfBoundsException(sb.toString());
        }
    }

    public static byte[] xor(byte[] arr1, byte[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 must not be null.");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 must not be null.");
        }
        if (arr1.length != arr2.length) {
            throw new IllegalArgumentException("arr1.length must equal to arr2.length.");
        }
        byte[] result = new byte[arr1.length];
        for (int i = 0; i < arr1.length; ++i) {
            result[i] = (byte)(arr1[i] ^ arr2[i]);
        }
        return result;
    }

    public static byte[] concatenate(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }
}

