/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpPacket;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpV4Packet
extends AbstractPacket
implements IpPacket {
    private static final long serialVersionUID = 5348211496230027548L;
    private static final Logger logger = LoggerFactory.getLogger(IpV4Packet.class);
    private final IpV4Header header;
    private final Packet payload;

    public static IpV4Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IpV4Packet(rawData, offset, length);
    }

    private IpV4Packet(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int payloadLength;
        this.header = new IpV4Header(rawData, offset, length);
        int remainingRawDataLength = length - this.header.length();
        int totalLength = this.header.getTotalLengthAsInt();
        if (totalLength == 0) {
            logger.debug("Total Length is 0. Assuming segmentation offload to be working.");
            payloadLength = remainingRawDataLength;
        } else {
            payloadLength = totalLength - this.header.length();
            if (payloadLength < 0) {
                throw new IllegalRawDataException("The value of total length field seems to be wrong: " + totalLength);
            }
            if (payloadLength > remainingRawDataLength) {
                payloadLength = remainingRawDataLength;
            }
        }
        this.payload = payloadLength != 0 ? (this.header.getMoreFragmentFlag() || this.header.getFragmentOffset() != 0 ? PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, this.header.length() + offset, payloadLength, NotApplicable.FRAGMENTED) : PacketFactories.getFactory(Packet.class, IpNumber.class).newInstance(rawData, this.header.length() + offset, payloadLength, this.header.getProtocol())) : null;
    }

    private IpV4Packet(Builder builder) {
        if (builder == null || builder.version == null || builder.tos == null || builder.protocol == null || builder.srcAddr == null || builder.dstAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.version: ").append(builder.version).append(" builder.tos: ").append(builder.tos).append(" builder.protocol: ").append(builder.protocol).append(" builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV4Header(builder, this.payload);
    }

    @Override
    public IpV4Header getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static interface IpV4Tos
    extends Serializable {
        public byte value();
    }

    public static interface IpV4Option
    extends Serializable {
        public IpV4OptionType getType();

        public int length();

        public byte[] getRawData();
    }

    public static final class IpV4Header
    extends AbstractPacket.AbstractHeader
    implements IpPacket.IpHeader {
        private static final long serialVersionUID = -7583326842445453539L;
        private static final Logger logger = LoggerFactory.getLogger(IpV4Header.class);
        private static final int VERSION_AND_IHL_OFFSET = 0;
        private static final int VERSION_AND_IHL_SIZE = 1;
        private static final int TOS_OFFSET = 1;
        private static final int TOS_SIZE = 1;
        private static final int TOTAL_LENGTH_OFFSET = 2;
        private static final int TOTAL_LENGTH_SIZE = 2;
        private static final int IDENTIFICATION_OFFSET = 4;
        private static final int IDENTIFICATION_SIZE = 2;
        private static final int FLAGS_AND_FRAGMENT_OFFSET_OFFSET = 6;
        private static final int FLAGS_AND_FRAGMENT_OFFSET_SIZE = 2;
        private static final int TTL_OFFSET = 8;
        private static final int TTL_SIZE = 1;
        private static final int PROTOCOL_OFFSET = 9;
        private static final int PROTOCOL_SIZE = 1;
        private static final int HEADER_CHECKSUM_OFFSET = 10;
        private static final int HEADER_CHECKSUM_SIZE = 2;
        private static final int SRC_ADDR_OFFSET = 12;
        private static final int SRC_ADDR_SIZE = 4;
        private static final int DST_ADDR_OFFSET = 16;
        private static final int DST_ADDR_SIZE = 4;
        private static final int OPTIONS_OFFSET = 20;
        private static final int MIN_IPV4_HEADER_SIZE = 20;
        private final IpVersion version;
        private final byte ihl;
        private final IpV4Tos tos;
        private final short totalLength;
        private final short identification;
        private final boolean reservedFlag;
        private final boolean dontFragmentFlag;
        private final boolean moreFragmentFlag;
        private final short fragmentOffset;
        private final byte ttl;
        private final IpNumber protocol;
        private final short headerChecksum;
        private final Inet4Address srcAddr;
        private final Inet4Address dstAddr;
        private final List<IpV4Option> options;
        private final byte[] padding;

        private IpV4Header(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            int currentOffsetInHeader;
            if (length < 20) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IPv4 header. ").append("It must be at least ").append(20).append(" bytes. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            byte versionAndIhl = ByteArrays.getByte(rawData, 0 + offset);
            this.version = IpVersion.getInstance((byte)((versionAndIhl & 0xF0) >> 4));
            this.ihl = (byte)(versionAndIhl & 0xF);
            this.tos = PacketFactories.getFactory(IpV4Tos.class, NotApplicable.class).newInstance(rawData, 1 + offset, 1);
            this.totalLength = ByteArrays.getShort(rawData, 2 + offset);
            this.identification = ByteArrays.getShort(rawData, 4 + offset);
            short flagsAndFragmentOffset = ByteArrays.getShort(rawData, 6 + offset);
            this.reservedFlag = (flagsAndFragmentOffset & 0x8000) != 0;
            this.dontFragmentFlag = (flagsAndFragmentOffset & 0x4000) != 0;
            this.moreFragmentFlag = (flagsAndFragmentOffset & 0x2000) != 0;
            this.fragmentOffset = (short)(flagsAndFragmentOffset & 0x1FFF);
            this.ttl = ByteArrays.getByte(rawData, 8 + offset);
            this.protocol = IpNumber.getInstance(ByteArrays.getByte(rawData, 9 + offset));
            this.headerChecksum = ByteArrays.getShort(rawData, 10 + offset);
            this.srcAddr = ByteArrays.getInet4Address(rawData, 12 + offset);
            this.dstAddr = ByteArrays.getInet4Address(rawData, 16 + offset);
            int headerLength = this.getIhlAsInt() * 4;
            if (length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IPv4 header(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (headerLength < 20) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("The ihl must be equal or more than").append(5).append("but it is: ").append(this.getIhlAsInt());
                throw new IllegalRawDataException(sb.toString());
            }
            this.options = new ArrayList<IpV4Option>();
            try {
                IpV4Option newOne;
                for (currentOffsetInHeader = 20; currentOffsetInHeader < headerLength; currentOffsetInHeader += newOne.length()) {
                    IpV4OptionType type = IpV4OptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                    newOne = PacketFactories.getFactory(IpV4Option.class, IpV4OptionType.class).newInstance(rawData, currentOffsetInHeader + offset, headerLength - currentOffsetInHeader, type);
                    this.options.add(newOne);
                    if (!newOne.getType().equals(IpV4OptionType.END_OF_OPTION_LIST)) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.error("Exception occurred during analyzing IPv4 options: ", (Throwable)e);
            }
            int paddingLength = headerLength - currentOffsetInHeader;
            this.padding = paddingLength != 0 ? ByteArrays.getSubArray(rawData, currentOffsetInHeader + offset, paddingLength) : new byte[0];
        }

        private IpV4Header(Builder builder, Packet payload) {
            if ((builder.fragmentOffset & 0xE000) != 0) {
                throw new IllegalArgumentException("Invalid fragmentOffset: " + builder.fragmentOffset);
            }
            this.version = builder.version;
            this.tos = builder.tos;
            this.identification = builder.identification;
            this.reservedFlag = builder.reservedFlag;
            this.dontFragmentFlag = builder.dontFragmentFlag;
            this.moreFragmentFlag = builder.moreFragmentFlag;
            this.fragmentOffset = builder.fragmentOffset;
            this.ttl = builder.ttl;
            this.protocol = builder.protocol;
            this.srcAddr = builder.srcAddr;
            this.dstAddr = builder.dstAddr;
            this.options = builder.options != null ? new ArrayList<IpV4Option>(builder.options) : new ArrayList<IpV4Option>(0);
            if (builder.paddingAtBuild) {
                int mod = this.measureLengthWithoutPadding() % 4;
                this.padding = mod != 0 ? new byte[4 - mod] : new byte[0];
            } else if (builder.padding != null) {
                this.padding = new byte[builder.padding.length];
                System.arraycopy(builder.padding, 0, this.padding, 0, this.padding.length);
            } else {
                this.padding = new byte[0];
            }
            if (builder.correctLengthAtBuild) {
                this.ihl = (byte)(this.length() / 4);
                this.totalLength = payload != null ? (short)(payload.length() + this.length()) : (short)this.length();
            } else {
                if ((builder.ihl & 0xF0) != 0) {
                    throw new IllegalArgumentException("Invalid ihl: " + builder.ihl);
                }
                this.ihl = builder.ihl;
                this.totalLength = builder.totalLength;
            }
            this.headerChecksum = builder.correctChecksumAtBuild ? (PacketPropertiesLoader.getInstance().ipV4CalcChecksum() ? this.calcHeaderChecksum() : (short)0) : builder.headerChecksum;
        }

        private short calcHeaderChecksum() {
            byte[] data = this.buildRawData();
            for (int i = 0; i < 2; ++i) {
                data[10 + i] = 0;
            }
            return ByteArrays.calcChecksum(data);
        }

        @Override
        public IpVersion getVersion() {
            return this.version;
        }

        public byte getIhl() {
            return this.ihl;
        }

        public int getIhlAsInt() {
            return 0xFF & this.ihl;
        }

        public IpV4Tos getTos() {
            return this.tos;
        }

        public short getTotalLength() {
            return this.totalLength;
        }

        public int getTotalLengthAsInt() {
            return 0xFFFF & this.totalLength;
        }

        public short getIdentification() {
            return this.identification;
        }

        public int getIdentificationAsInt() {
            return 0xFFFF & this.identification;
        }

        public boolean getReservedFlag() {
            return this.reservedFlag;
        }

        public boolean getDontFragmentFlag() {
            return this.dontFragmentFlag;
        }

        public boolean getMoreFragmentFlag() {
            return this.moreFragmentFlag;
        }

        public short getFragmentOffset() {
            return this.fragmentOffset;
        }

        public byte getTtl() {
            return this.ttl;
        }

        public int getTtlAsInt() {
            return 0xFF & this.ttl;
        }

        @Override
        public IpNumber getProtocol() {
            return this.protocol;
        }

        public short getHeaderChecksum() {
            return this.headerChecksum;
        }

        @Override
        public Inet4Address getSrcAddr() {
            return this.srcAddr;
        }

        @Override
        public Inet4Address getDstAddr() {
            return this.dstAddr;
        }

        public List<IpV4Option> getOptions() {
            return new ArrayList<IpV4Option>(this.options);
        }

        public byte[] getPadding() {
            byte[] copy = new byte[this.padding.length];
            System.arraycopy(this.padding, 0, copy, 0, this.padding.length);
            return copy;
        }

        public boolean hasValidChecksum(boolean acceptZero) {
            if (this.headerChecksum == 0) {
                return acceptZero;
            }
            return this.calcHeaderChecksum() == this.headerChecksum;
        }

        @Override
        protected List<byte[]> getRawFields() {
            int flags = 0;
            if (this.moreFragmentFlag) {
                flags = 1;
            }
            if (this.dontFragmentFlag) {
                flags = (byte)(flags | 2);
            }
            if (this.reservedFlag) {
                flags = (byte)(flags | 4);
            }
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((byte)((Byte)this.version.value() << 4 | this.ihl)));
            rawFields.add(new byte[]{this.tos.value()});
            rawFields.add(ByteArrays.toByteArray(this.totalLength));
            rawFields.add(ByteArrays.toByteArray(this.identification));
            rawFields.add(ByteArrays.toByteArray((short)(flags << 13 | this.fragmentOffset)));
            rawFields.add(ByteArrays.toByteArray(this.ttl));
            rawFields.add(ByteArrays.toByteArray((Byte)this.protocol.value()));
            rawFields.add(ByteArrays.toByteArray(this.headerChecksum));
            rawFields.add(ByteArrays.toByteArray(this.srcAddr));
            rawFields.add(ByteArrays.toByteArray(this.dstAddr));
            for (IpV4Option o : this.options) {
                rawFields.add(o.getRawData());
            }
            rawFields.add(this.padding);
            return rawFields;
        }

        private int measureLengthWithoutPadding() {
            int len = 0;
            for (IpV4Option o : this.options) {
                len += o.length();
            }
            return len + 20;
        }

        @Override
        protected int calcLength() {
            return this.measureLengthWithoutPadding() + this.padding.length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv4 Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Version: ").append(this.version).append(ls);
            sb.append("  IHL: ").append(this.ihl).append(" (").append(this.ihl * 4).append(" [bytes])").append(ls);
            sb.append("  TOS: ").append(this.tos).append(ls);
            sb.append("  Total length: ").append(this.getTotalLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Identification: ").append(this.getIdentificationAsInt()).append(ls);
            sb.append("  Flags: (Reserved, Don't Fragment, More Fragment) = (").append(this.getReservedFlag()).append(", ").append(this.getDontFragmentFlag()).append(", ").append(this.getMoreFragmentFlag()).append(")").append(ls);
            sb.append("  Fragment offset: ").append(this.fragmentOffset).append(" (").append(this.fragmentOffset * 8).append(" [bytes])").append(ls);
            sb.append("  TTL: ").append(this.getTtlAsInt()).append(ls);
            sb.append("  Protocol: ").append(this.protocol).append(ls);
            sb.append("  Header checksum: 0x").append(ByteArrays.toHexString(this.headerChecksum, "")).append(ls);
            sb.append("  Source address: ").append(this.srcAddr).append(ls);
            sb.append("  Destination address: ").append(this.dstAddr).append(ls);
            for (IpV4Option opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            if (this.padding.length != 0) {
                sb.append("  Padding: 0x").append(ByteArrays.toHexString(this.padding, " ")).append(ls);
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            IpV4Header other = (IpV4Header)obj;
            return this.identification == other.identification && this.headerChecksum == other.headerChecksum && this.srcAddr.equals(other.srcAddr) && this.dstAddr.equals(other.dstAddr) && this.totalLength == other.totalLength && this.protocol.equals(other.protocol) && this.ttl == other.ttl && this.fragmentOffset == other.fragmentOffset && this.reservedFlag == other.reservedFlag && this.dontFragmentFlag == other.dontFragmentFlag && this.moreFragmentFlag == other.moreFragmentFlag && this.tos.equals(other.tos) && this.ihl == other.ihl && this.version.equals(other.version) && this.options.equals(other.options) && Arrays.equals(this.padding, other.padding);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.version.hashCode();
            result = 31 * result + this.ihl;
            result = 31 * result + this.tos.hashCode();
            result = 31 * result + this.totalLength;
            result = 31 * result + this.identification;
            result = 31 * result + (this.reservedFlag ? 1231 : 1237);
            result = 31 * result + (this.dontFragmentFlag ? 1231 : 1237);
            result = 31 * result + (this.moreFragmentFlag ? 1231 : 1237);
            result = 31 * result + this.fragmentOffset;
            result = 31 * result + this.ttl;
            result = 31 * result + this.protocol.hashCode();
            result = 31 * result + this.headerChecksum;
            result = 31 * result + this.srcAddr.hashCode();
            result = 31 * result + this.dstAddr.hashCode();
            result = 31 * result + Arrays.hashCode(this.padding);
            result = 31 * result + this.options.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements ChecksumBuilder<IpV4Packet>,
    LengthBuilder<IpV4Packet> {
        private IpVersion version;
        private byte ihl;
        private IpV4Tos tos;
        private short totalLength;
        private short identification;
        private boolean reservedFlag;
        private boolean dontFragmentFlag;
        private boolean moreFragmentFlag;
        private short fragmentOffset;
        private byte ttl;
        private IpNumber protocol;
        private short headerChecksum;
        private Inet4Address srcAddr;
        private Inet4Address dstAddr;
        private List<IpV4Option> options;
        private byte[] padding;
        private Packet.Builder payloadBuilder;
        private boolean correctChecksumAtBuild;
        private boolean correctLengthAtBuild;
        private boolean paddingAtBuild;

        public Builder() {
        }

        public Builder(IpV4Packet packet) {
            this.version = packet.header.version;
            this.ihl = packet.header.ihl;
            this.tos = packet.header.tos;
            this.totalLength = packet.header.totalLength;
            this.identification = packet.header.identification;
            this.reservedFlag = packet.header.reservedFlag;
            this.dontFragmentFlag = packet.header.dontFragmentFlag;
            this.moreFragmentFlag = packet.header.moreFragmentFlag;
            this.fragmentOffset = packet.header.fragmentOffset;
            this.ttl = packet.header.ttl;
            this.protocol = packet.header.protocol;
            this.headerChecksum = packet.header.headerChecksum;
            this.srcAddr = packet.header.srcAddr;
            this.dstAddr = packet.header.dstAddr;
            this.options = packet.header.options;
            this.padding = packet.header.padding;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder version(IpVersion version) {
            this.version = version;
            return this;
        }

        public Builder ihl(byte ihl) {
            this.ihl = ihl;
            return this;
        }

        public Builder tos(IpV4Tos tos) {
            this.tos = tos;
            return this;
        }

        public Builder totalLength(short totalLength) {
            this.totalLength = totalLength;
            return this;
        }

        public Builder identification(short identification) {
            this.identification = identification;
            return this;
        }

        public Builder reservedFlag(boolean reservedFlag) {
            this.reservedFlag = reservedFlag;
            return this;
        }

        public Builder dontFragmentFlag(boolean dontFragmentFlag) {
            this.dontFragmentFlag = dontFragmentFlag;
            return this;
        }

        public Builder moreFragmentFlag(boolean moreFragmentFlag) {
            this.moreFragmentFlag = moreFragmentFlag;
            return this;
        }

        public Builder fragmentOffset(short fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Builder ttl(byte ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder protocol(IpNumber protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder headerChecksum(short headerChecksum) {
            this.headerChecksum = headerChecksum;
            return this;
        }

        public Builder srcAddr(Inet4Address srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder dstAddr(Inet4Address dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder options(List<IpV4Option> options) {
            this.options = options;
            return this;
        }

        public Builder padding(byte[] padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        public Builder paddingAtBuild(boolean paddingAtBuild) {
            this.paddingAtBuild = paddingAtBuild;
            return this;
        }

        @Override
        public IpV4Packet build() {
            return new IpV4Packet(this);
        }
    }
}

