/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.util.regex.Matcher;
import org.pcap4j.packet.namednumber.Oui;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LinkLayerAddress;

public final class MacAddress
extends LinkLayerAddress {
    private static final long serialVersionUID = -8222662646993989547L;
    public static final MacAddress ETHER_BROADCAST_ADDRESS = MacAddress.getByAddress(new byte[]{-1, -1, -1, -1, -1, -1});
    public static final int SIZE_IN_BYTES = 6;

    private MacAddress(byte[] address) {
        super(address);
    }

    public static MacAddress getByAddress(byte[] address) {
        if (address.length != 6) {
            throw new IllegalArgumentException(ByteArrays.toHexString(address, ":") + " is invalid for address. The length must be " + 6);
        }
        return new MacAddress(ByteArrays.clone(address));
    }

    public static MacAddress getByName(String name) {
        Matcher m = HEX_SEPARATOR_PATTERN.matcher(name);
        m.find();
        return MacAddress.getByName(name, m.group(1));
    }

    public static MacAddress getByName(String name, String separator) {
        return MacAddress.getByAddress(ByteArrays.parseByteArray(name, separator));
    }

    public Oui getOui() {
        return Oui.getInstance(ByteArrays.getInt(this.getAddress(), 0) >>> 8);
    }

    public boolean isUnicast() {
        return (this.getAddress()[0] & 1) == 0;
    }

    public boolean isGloballyUnique() {
        return (this.getAddress()[0] & 2) == 0;
    }
}

