/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.pcap4j.util.ByteArrays;

public final class IpV4SecurityOptionTransmissionControlCode
extends NamedNumber<Integer, IpV4SecurityOptionTransmissionControlCode> {
    private static final long serialVersionUID = 3041825811304706489L;
    private static final Map<Integer, IpV4SecurityOptionTransmissionControlCode> registry = new HashMap<Integer, IpV4SecurityOptionTransmissionControlCode>();

    public IpV4SecurityOptionTransmissionControlCode(Integer value, String name) {
        super(value, name);
        if ((value & 0xFF000000) != 0) {
            throw new IllegalArgumentException(value + " is invalid value. " + "The value must be between 0 and 16777215");
        }
    }

    public static IpV4SecurityOptionTransmissionControlCode getInstance(Integer value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new IpV4SecurityOptionTransmissionControlCode(value, "unknown");
    }

    public static IpV4SecurityOptionTransmissionControlCode register(IpV4SecurityOptionTransmissionControlCode number) {
        return registry.put((Integer)number.value(), number);
    }

    @Override
    public String valueAsString() {
        return "0x" + ByteArrays.toHexString((Integer)this.value(), "");
    }

    @Override
    public int compareTo(IpV4SecurityOptionTransmissionControlCode o) {
        return ((Integer)this.value()).compareTo((Integer)o.value());
    }
}

