/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.ArpHardwareType;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.LinuxSllPacketType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LinkLayerAddress;

public final class LinuxSllPacket
extends AbstractPacket {
    private static final long serialVersionUID = -7743587634024281470L;
    private final LinuxSllHeader header;
    private final Packet payload;

    public static LinuxSllPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new LinuxSllPacket(rawData, offset, length);
    }

    private LinuxSllPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new LinuxSllHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, offset + this.header.length(), payloadLength, this.header.getProtocol()) : null;
    }

    private LinuxSllPacket(Builder builder) {
        if (builder == null || builder.packetType == null || builder.hardwareType == null || builder.address == null || builder.protocol == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.packetType: ").append(builder.packetType).append(" builder.hardwareType: ").append(builder.hardwareType).append(" builder.address: ").append(builder.address).append(" builder.protocol: ").append(builder.protocol);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new LinuxSllHeader(builder);
    }

    @Override
    public LinuxSllHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class LinuxSllHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8284608139785829230L;
        private static final int PPKTTYPE_OFFSET = 0;
        private static final int PPKTTYPE_SIZE = 2;
        private static final int PHATYPE_OFFSET = 2;
        private static final int PHATYPE_SIZE = 2;
        private static final int HALEN_OFFSET = 4;
        private static final int HALEN_SIZE = 2;
        private static final int ADDR_OFFSET = 6;
        private static final int ADDR_SIZE = 8;
        private static final int PROTOCOL_OFFSET = 14;
        private static final int PROTOCOL_SIZE = 2;
        private static final int LINUX_SLL_HEADER_SIZE = 16;
        private final LinuxSllPacketType packetType;
        private final ArpHardwareType hardwareType;
        private final short hardwareLength;
        private final byte[] addressField = new byte[8];
        private final LinkLayerAddress address;
        private final EtherType protocol;

        private LinuxSllHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 16) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("The data is too short to build a Linux SLL header(").append(16).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.packetType = LinuxSllPacketType.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.hardwareType = ArpHardwareType.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.hardwareLength = ByteArrays.getShort(rawData, 4 + offset);
            if (this.getHardwareLengthAsInt() > 8) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("hardwareLength must not be longer than ").append(8).append(" but it is: ").append(this.getHardwareLengthAsInt());
                throw new IllegalRawDataException(sb.toString());
            }
            if (this.hardwareLength == 0) {
                throw new IllegalRawDataException("hardwareLength must not be 0.");
            }
            System.arraycopy(rawData, 6 + offset, this.addressField, 0, 8);
            this.address = ByteArrays.getLinkLayerAddress(rawData, 6 + offset, this.getHardwareLengthAsInt());
            this.protocol = EtherType.getInstance(ByteArrays.getShort(rawData, 14 + offset));
        }

        private LinuxSllHeader(Builder builder) {
            if (builder.address.length > 8) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("address must not be longer than ").append(8).append(" but it is: ").append(ByteArrays.toHexString(builder.address, " "));
                throw new IllegalArgumentException(sb.toString());
            }
            this.packetType = builder.packetType;
            this.hardwareType = builder.hardwareType;
            this.hardwareLength = builder.hardwareLength;
            System.arraycopy(builder.address, 0, this.addressField, 0, builder.address.length);
            this.protocol = builder.protocol;
            this.address = this.getHardwareLengthAsInt() > 8 ? LinkLayerAddress.getByAddress(this.addressField) : ByteArrays.getLinkLayerAddress(this.addressField, 0, this.getHardwareLengthAsInt());
        }

        public LinuxSllPacketType getPacketType() {
            return this.packetType;
        }

        public ArpHardwareType getHardwareType() {
            return this.hardwareType;
        }

        public short getHardwareLength() {
            return this.hardwareLength;
        }

        public int getHardwareLengthAsInt() {
            return 0xFFFF & this.hardwareLength;
        }

        public LinkLayerAddress getAddress() {
            return this.address;
        }

        public byte[] getAddressField() {
            return ByteArrays.clone(this.addressField);
        }

        public EtherType getProtocol() {
            return this.protocol;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.packetType.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.hardwareType.value()));
            rawFields.add(ByteArrays.toByteArray(this.hardwareLength));
            rawFields.add(this.addressField);
            rawFields.add(ByteArrays.toByteArray((Short)this.protocol.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 16;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[Linux SLL header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Packet Type: ").append(this.packetType).append(ls);
            sb.append("  Hardware Type: ").append(this.hardwareType).append(ls);
            sb.append("  Hardware Length: ").append(this.getHardwareLengthAsInt()).append(ls);
            sb.append("  Address: ").append(this.address).append(" (").append(ByteArrays.toHexString(this.addressField, " ")).append(")").append(ls);
            sb.append("  Protocol: ").append(this.protocol).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            LinuxSllHeader other = (LinuxSllHeader)obj;
            return Arrays.equals(this.addressField, other.addressField) && this.packetType.equals(other.packetType) && this.protocol.equals(other.protocol) && this.hardwareType.equals(other.hardwareType) && this.hardwareLength == other.hardwareLength;
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.packetType.hashCode();
            result = 31 * result + this.hardwareType.hashCode();
            result = 31 * result + this.hardwareLength;
            result = 31 * result + Arrays.hashCode(this.addressField);
            result = 31 * result + this.protocol.hashCode();
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private LinuxSllPacketType packetType;
        private ArpHardwareType hardwareType;
        private short hardwareLength;
        private byte[] address;
        private EtherType protocol;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(LinuxSllPacket packet) {
            this.packetType = packet.header.packetType;
            this.hardwareType = packet.header.hardwareType;
            this.hardwareLength = packet.header.hardwareLength;
            this.address = packet.header.addressField;
            this.protocol = packet.header.protocol;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder packetType(LinuxSllPacketType packetType) {
            this.packetType = packetType;
            return this;
        }

        public Builder hardwareType(ArpHardwareType hardwareType) {
            this.hardwareType = hardwareType;
            return this;
        }

        public Builder hardwareLength(short hardwareLength) {
            this.hardwareLength = hardwareLength;
            return this;
        }

        public Builder address(byte[] address) {
            this.address = address;
            return this;
        }

        public Builder protocol(EtherType protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public LinuxSllPacket build() {
            return new LinuxSllPacket(this);
        }
    }
}

