/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class UdpPort
extends NamedNumber<Short, UdpPort> {
    private static final long serialVersionUID = -7898348444366318292L;
    public static final UdpPort SNMP = new UdpPort((short)161, "SNMP");
    public static final UdpPort SNMP_TRAP = new UdpPort((short)162, "SNMP Trap");
    private static final Map<Short, UdpPort> registry = new HashMap<Short, UdpPort>();

    public UdpPort(Short value, String name) {
        super(value, name);
    }

    public static UdpPort getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new UdpPort(value, "unknown");
    }

    public static UdpPort register(UdpPort port) {
        return registry.put((Short)port.value(), port);
    }

    public int valueAsInt() {
        return 0xFFFF & (Short)this.value();
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.valueAsInt());
    }

    @Override
    public int compareTo(UdpPort o) {
        return ((Short)this.value()).compareTo((Short)o.value());
    }

    static {
        for (Field field : UdpPort.class.getFields()) {
            if (!UdpPort.class.isAssignableFrom(field.getType())) continue;
            try {
                UdpPort f = (UdpPort)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

