/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class TcpPort
extends NamedNumber<Short, TcpPort> {
    private static final long serialVersionUID = 3906499626286793530L;
    public static final TcpPort FTP_DATA = new TcpPort((short)20, "FTP-data");
    public static final TcpPort FTP = new TcpPort((short)21, "FTP");
    public static final TcpPort SSH = new TcpPort((short)22, "SSH");
    public static final TcpPort TELNET = new TcpPort((short)23, "Telnet");
    public static final TcpPort HTTP = new TcpPort((short)80, "HTTP");
    public static final TcpPort SNMP = new TcpPort((short)161, "SNMP");
    public static final TcpPort SNMP_TRAP = new TcpPort((short)162, "SNMP Trap");
    private static final Map<Short, TcpPort> registry = new HashMap<Short, TcpPort>();

    public TcpPort(Short value, String name) {
        super(value, name);
    }

    public static TcpPort getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new TcpPort(value, "unknown");
    }

    public static TcpPort register(TcpPort port) {
        return registry.put((Short)port.value(), port);
    }

    public int valueAsInt() {
        return 0xFFFF & (Short)this.value();
    }

    @Override
    public String valueAsString() {
        return String.valueOf(this.valueAsInt());
    }

    @Override
    public int compareTo(TcpPort o) {
        return ((Short)this.value()).compareTo((Short)o.value());
    }

    static {
        for (Field field : TcpPort.class.getFields()) {
            if (!TcpPort.class.isAssignableFrom(field.getType())) continue;
            try {
                TcpPort f = (TcpPort)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

