/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class TcpOptionKind
extends NamedNumber<Byte, TcpOptionKind> {
    private static final long serialVersionUID = -7033971699970069137L;
    public static final TcpOptionKind END_OF_OPTION_LIST = new TcpOptionKind((byte)0, "End of Option List");
    public static final TcpOptionKind NO_OPERATION = new TcpOptionKind((byte)1, "No Operation");
    public static final TcpOptionKind MAXIMUM_SEGMENT_SIZE = new TcpOptionKind((byte)2, "Maximum Segment Size");
    public static final TcpOptionKind WINDOW_SCALE = new TcpOptionKind((byte)3, "Window Scale");
    public static final TcpOptionKind SACK_PERMITTED = new TcpOptionKind((byte)4, "SACK Permitted");
    public static final TcpOptionKind SACK = new TcpOptionKind((byte)5, "SACK");
    public static final TcpOptionKind TIMESTAMPS = new TcpOptionKind((byte)8, "Timestamps");
    private static final Map<Byte, TcpOptionKind> registry = new HashMap<Byte, TcpOptionKind>();

    public TcpOptionKind(Byte value, String name) {
        super(value, name);
    }

    public static TcpOptionKind getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new TcpOptionKind(value, "unknown");
    }

    public static TcpOptionKind register(TcpOptionKind type) {
        return registry.put((Byte)type.value(), type);
    }

    @Override
    public int compareTo(TcpOptionKind o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        for (Field field : TcpOptionKind.class.getFields()) {
            if (!TcpOptionKind.class.isAssignableFrom(field.getType())) continue;
            try {
                TcpOptionKind f = (TcpOptionKind)field.get(null);
                registry.put((Byte)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

