/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class ArpOperation
extends NamedNumber<Short, ArpOperation> {
    private static final long serialVersionUID = 5558693543482950163L;
    public static final ArpOperation REQUEST = new ArpOperation((short)1, "REQUEST");
    public static final ArpOperation REPLY = new ArpOperation((short)2, "REPLY");
    private static final Map<Short, ArpOperation> registry = new HashMap<Short, ArpOperation>();

    public ArpOperation(Short value, String name) {
        super(value, name);
    }

    public static ArpOperation getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new ArpOperation(value, "unknown");
    }

    public static ArpOperation register(ArpOperation operation) {
        return registry.put((Short)operation.value(), operation);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Short)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(ArpOperation o) {
        return ((Short)this.value()).compareTo((Short)o.value());
    }

    static {
        for (Field field : ArpOperation.class.getFields()) {
            if (!ArpOperation.class.isAssignableFrom(field.getType())) continue;
            try {
                ArpOperation f = (ArpOperation)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

